/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.stash.internal.user.InternalPermissionService;
import com.atlassian.stash.internal.user.StashUserAuthenticationToken;
import com.google.common.base.Preconditions;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.FilterInvocation;
import org.springframework.security.web.access.expression.WebSecurityExpressionRoot;

public class ExtendedWebSecurityExpressionRoot
extends WebSecurityExpressionRoot {
    private final InternalPermissionService permissionService;

    public ExtendedWebSecurityExpressionRoot(Authentication a, FilterInvocation fi, InternalPermissionService permissionService) {
        super(a, fi);
        this.permissionService = permissionService;
    }

    public boolean hasGlobalPermission(String permission) {
        Permission requestedPerm = Permission.valueOf((String)permission);
        Preconditions.checkArgument((boolean)requestedPerm.isGlobal());
        return this.permissionService.hasGlobalPermission(this.resolveAuthenticationToken(), requestedPerm);
    }

    private StashUserAuthenticationToken resolveAuthenticationToken() {
        if (this.authentication instanceof StashUserAuthenticationToken) {
            return (StashUserAuthenticationToken)this.authentication;
        }
        return null;
    }
}

