/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.user;

import com.atlassian.bitbucket.permission.EffectivePermissionsChangedEvent;
import com.atlassian.bitbucket.permission.EffectivePermissionsProvider;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginFrameworkShuttingDownEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.osgi.container.OsgiContainerManager;
import com.atlassian.stash.internal.user.EffectivePermissionsProviderTracker;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="effectivePermissionsProviderTracker")
public class DefaultEffectivePermissionsProviderTracker
implements ServiceTrackerCustomizer<EffectivePermissionsProvider, EffectivePermissionsProvider>,
EffectivePermissionsProviderTracker {
    private static final Logger log = LoggerFactory.getLogger(DefaultEffectivePermissionsProviderTracker.class);
    private final OsgiContainerManager containerManager;
    private final EventPublisher eventPublisher;
    private final Set<EffectivePermissionsProvider> providers;
    private BundleContext bundleContext;
    private ServiceTracker<EffectivePermissionsProvider, EffectivePermissionsProvider> serviceTracker;

    @Autowired
    public DefaultEffectivePermissionsProviderTracker(OsgiContainerManager containerManager, EventPublisher eventPublisher) {
        this.containerManager = containerManager;
        this.eventPublisher = eventPublisher;
        this.providers = Collections.newSetFromMap(Maps.newConcurrentMap());
    }

    public EffectivePermissionsProvider addingService(ServiceReference<EffectivePermissionsProvider> serviceReference) {
        EffectivePermissionsProvider provider = (EffectivePermissionsProvider)this.bundleContext.getService(serviceReference);
        if (provider == null) {
            log.debug("Failed to resolve EffectivePermissionsProvider from bundle {} for reference {}", (Object)serviceReference.getBundle(), serviceReference);
            return null;
        }
        this.providers.add(provider);
        this.fireEvent();
        return provider;
    }

    @Override
    @Nonnull
    public Set<EffectivePermissionsProvider> getProviders() {
        return Collections.unmodifiableSet(this.providers);
    }

    public void modifiedService(ServiceReference<EffectivePermissionsProvider> reference, EffectivePermissionsProvider service) {
    }

    @EventListener
    public void onPluginFrameworkShuttingDown(PluginFrameworkShuttingDownEvent event) {
        this.providers.clear();
        try {
            this.fireEvent();
        }
        finally {
            if (this.serviceTracker != null) {
                this.serviceTracker.close();
            }
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent event) {
        this.bundleContext = this.containerManager.getBundles()[0].getBundleContext();
        this.serviceTracker = new ServiceTracker(this.bundleContext, EffectivePermissionsProvider.class, (ServiceTrackerCustomizer)this);
        this.serviceTracker.open();
    }

    public void removedService(ServiceReference<EffectivePermissionsProvider> reference, EffectivePermissionsProvider service) {
        this.bundleContext.ungetService(reference);
        if (!this.providers.remove(service)) {
            log.debug("Removed service EffectivePermissionsProvider of type {} for reference {} was not being tracked", (Object)service.getClass().getName(), reference);
            return;
        }
        this.fireEvent();
    }

    private void fireEvent() {
        this.eventPublisher.publish((Object)new EffectivePermissionsChangedEvent((Object)this));
    }
}

