/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.server;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.cache.Cache;
import com.atlassian.cache.CacheEntryAdapter;
import com.atlassian.cache.CacheEntryEvent;
import com.atlassian.cache.CacheEntryListener;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.stash.internal.server.ProfilingService;
import com.atlassian.util.profiling.UtilTimerStack;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="profilingService")
public class DefaultProfilingService
implements ProfilingService {
    private static final String KEY_ENABLED = "enabled";
    private static final String MAP_PROFILING = "profiling";
    private final ApplicationPropertiesService applicationPropertiesService;
    private final ProfilingStateListener listener;
    private final Cache<String, Integer> profilingState;

    @Autowired
    public DefaultProfilingService(ApplicationPropertiesService applicationPropertiesService, CacheFactory cacheFactory) {
        this.applicationPropertiesService = applicationPropertiesService;
        this.listener = new ProfilingStateListener();
        this.profilingState = cacheFactory.getCache(MAP_PROFILING, null, new CacheSettingsBuilder().remote().build());
        this.profilingState.addListener((CacheEntryListener)this.listener, true);
    }

    public void disable() {
        this.profilingState.remove((Object)KEY_ENABLED);
    }

    public void enable() {
        this.enable(0);
    }

    public void enable(int profilingThreshold) {
        this.profilingState.put((Object)KEY_ENABLED, (Object)profilingThreshold);
    }

    public boolean isEnabled() {
        return this.profilingState.containsKey((Object)KEY_ENABLED);
    }

    private void doDisable() {
        UtilTimerStack.setActive((boolean)false);
    }

    private void doEnable(Integer profilingThreshold) {
        UtilTimerStack.setActive((boolean)true);
        UtilTimerStack.setMinTotalTime((long)profilingThreshold.intValue());
        if (System.getProperty("atlassian.profile.mintime") == null) {
            UtilTimerStack.setMinTime((long)1L);
        }
    }

    @PostConstruct
    protected void onStartup() {
        Integer threshold = (Integer)this.profilingState.get((Object)KEY_ENABLED);
        if (threshold != null) {
            this.doEnable(threshold);
        } else if (this.applicationPropertiesService.isProfilingEnabled()) {
            this.enable(0);
        }
    }

    @PreDestroy
    private void onShutdown() {
        this.profilingState.removeListener((CacheEntryListener)this.listener);
    }

    private class ProfilingStateListener
    extends CacheEntryAdapter<String, Integer> {
        private ProfilingStateListener() {
        }

        public void onAdd(@Nonnull CacheEntryEvent<String, Integer> event) {
            DefaultProfilingService.this.doEnable((Integer)event.getValue());
        }

        public void onEvict(@Nonnull CacheEntryEvent<String, Integer> event) {
            DefaultProfilingService.this.doDisable();
        }

        public void onRemove(@Nonnull CacheEntryEvent<String, Integer> event) {
            DefaultProfilingService.this.doDisable();
        }

        public void onUpdate(@Nonnull CacheEntryEvent<String, Integer> event) {
            DefaultProfilingService.this.doEnable((Integer)event.getValue());
        }
    }
}

