/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.compare.CompareRequest;
import com.atlassian.bitbucket.event.cluster.ClusterNodeAddedEvent;
import com.atlassian.bitbucket.hook.ScmHookHandlerFactory;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.AvailableScm;
import com.atlassian.bitbucket.scm.DeleteCommandParameters;
import com.atlassian.bitbucket.scm.FeatureUnsupportedScmException;
import com.atlassian.bitbucket.scm.PluginCommandBuilderFactory;
import com.atlassian.bitbucket.scm.Scm;
import com.atlassian.bitbucket.scm.ScmCommandBuilder;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmFeature;
import com.atlassian.bitbucket.scm.ScmModuleDescriptor;
import com.atlassian.bitbucket.scm.ScmProtocol;
import com.atlassian.bitbucket.scm.ScmProtocolModuleDescriptor;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.UnavailableScmException;
import com.atlassian.bitbucket.scm.UnsupportedScmException;
import com.atlassian.bitbucket.scm.UnsupportedScmTypeException;
import com.atlassian.bitbucket.scm.bulk.PluginBulkContentCommandFactory;
import com.atlassian.bitbucket.scm.bulk.ScmBulkContentCommandFactory;
import com.atlassian.bitbucket.scm.compare.PluginCompareCommandFactory;
import com.atlassian.bitbucket.scm.compare.ScmCompareCommandFactory;
import com.atlassian.bitbucket.scm.event.ScmStatusChangedEvent;
import com.atlassian.bitbucket.scm.hook.PluginHookHandlerFactory;
import com.atlassian.bitbucket.scm.mirror.PluginMirrorCommandFactory;
import com.atlassian.bitbucket.scm.mirror.ScmMirrorCommandFactory;
import com.atlassian.bitbucket.scm.pull.PluginPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.pull.RepositoryRescopeCommandParameters;
import com.atlassian.bitbucket.scm.pull.ScmPullRequestCommandFactory;
import com.atlassian.bitbucket.scm.ref.PluginRefCommandFactory;
import com.atlassian.bitbucket.scm.ref.ScmRefCommandFactory;
import com.atlassian.bitbucket.util.Drainable;
import com.atlassian.bitbucket.util.ForcedDrainable;
import com.atlassian.bitbucket.util.ModuleDescriptorUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.johnson.event.AddEvent;
import com.atlassian.johnson.event.Event;
import com.atlassian.johnson.event.EventLevel;
import com.atlassian.johnson.event.EventType;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.events.BeforePluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginFrameworkStartedEvent;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.db.DatabaseManager;
import com.atlassian.stash.internal.hook.PluginScmHookHandlerFactory;
import com.atlassian.stash.internal.maintenance.latch.ClusterableLatch;
import com.atlassian.stash.internal.maintenance.latch.LatchMode;
import com.atlassian.stash.internal.maintenance.latch.LatchState;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.atlassian.stash.internal.scm.PluginScmBulkContentCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmCompareCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmMirrorCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmPullRequestCommandFactory;
import com.atlassian.stash.internal.scm.PluginScmRefCommandFactory;
import com.atlassian.stash.internal.scm.ScmLatch;
import com.atlassian.stash.internal.scm.SimpleAvailableScm;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import com.hazelcast.core.Cluster;
import com.hazelcast.core.IExecutorService;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@AvailableToPlugins(value=ScmService.class)
@Service(value="scmService")
public class PluginScmService
implements InternalScmService,
BeanNameAware {
    private static final Predicate<Scm> IS_AVAILABLE = scm -> scm.getStatus().isAvailable();
    private static final String SCM_GIT = "git";
    private static final String STARS = StringUtils.repeat((String)"*", (int)75);
    private static final Logger log = LoggerFactory.getLogger(PluginScmService.class);
    private final LoadingCache<String, Scm> cache = CacheBuilder.newBuilder().build(CacheLoader.from((Function)new Function<String, Scm>(){

        public Scm apply(String scmId) {
            log.debug("Cache miss for SCM {}; searching plugins", (Object)scmId);
            Scm scm = PluginScmService.this.getEnabledScms().filter(s -> StringUtils.equals((CharSequence)scmId, (CharSequence)s.getId())).findFirst().orElseThrow(() -> PluginScmService.this.unsupportedScm(scmId));
            if (!scm.getStatus().isAvailable()) {
                throw PluginScmService.this.unavailableScm(scmId, scm.getStatus().getMessage());
            }
            return scm;
        }
    }));
    private final Cluster cluster;
    private final DatabaseManager databaseManager;
    private final EventPublisher eventPublisher;
    private final IExecutorService executorService;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private String beanName;
    private volatile DefaultScmLatch latch;

    @Autowired
    public PluginScmService(Cluster cluster, DatabaseManager databaseManager, EventPublisher eventPublisher, IExecutorService executorService, I18nService i18nService, PluginAccessor pluginAccessor) {
        this.cluster = cluster;
        this.databaseManager = databaseManager;
        this.eventPublisher = eventPublisher;
        this.executorService = executorService;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
    }

    @Nonnull
    public ScmLatch acquireLatch(@Nonnull LatchMode latchMode) {
        return this.acquireLatch(latchMode, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public ScmLatch acquireLatch(@Nonnull LatchMode mode, String latchId) {
        String string = SCM_GIT;
        synchronized (SCM_GIT) {
            Preconditions.checkState((!this.isLatched() ? 1 : 0) != 0, (Object)"SCMs have already been latched");
            Preconditions.checkState((boolean)this.databaseManager.isLatched(), (Object)"SCMs can only be latched after the database is latched");
            try {
                this.latch = new DefaultScmLatch(mode);
                this.latch.acquire(latchId);
            }
            finally {
                if (!this.latch.isAcquired()) {
                    this.latch = null;
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return this.latch;
        }
    }

    @Nonnull
    public ScmCommandBuilder<?> createBuilder(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginCommandBuilderFactory builderFactory = scm.getCommandBuilderFactory();
        if (builderFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.COMMAND_BUILDERS);
        }
        return builderFactory.builder(repository);
    }

    public void delete(@Nonnull Repository repository, @Nonnull DeleteCommandParameters parameters) {
        Preconditions.checkNotNull((Object)parameters, (Object)"parameters");
        this.findByRepository(repository).getCommandFactory().delete(repository, parameters).synchronous().call();
    }

    @Nonnull
    public Scm findById(@Nonnull String scmId) {
        Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)((CharSequence)Preconditions.checkNotNull((Object)scmId, (Object)"scmId"))), (Object)"An scmId is required to locate an SCM");
        try {
            return (Scm)this.cache.getUnchecked((Object)scmId);
        }
        catch (UncheckedExecutionException e) {
            throw (RuntimeException)e.getCause();
        }
    }

    @Nonnull
    public Scm findByRepository(@Nonnull Repository repository) {
        return this.findById(((Repository)Preconditions.checkNotNull((Object)repository, (Object)"repository")).getScmId());
    }

    @Nonnull
    public Set<AvailableScm> getAvailable() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        HashSet ids = Sets.newHashSet();
        this.getEnabledScms().forEach(scm -> {
            if (scm.getStatus().isAvailable()) {
                String id = scm.getId();
                if (ids.add(id)) {
                    builder.add((Object)new SimpleAvailableScm.Builder(id).name(scm.getName()).build());
                } else {
                    log.warn("Multiple SCMs have registered with ID {}; {} will be ignored", (Object)id, (Object)scm.getName());
                }
            }
        });
        return builder.build();
    }

    @Nonnull
    public ScmBulkContentCommandFactory getBulkContentCommandFactory(@Nonnull Repository repository) {
        return new PluginScmBulkContentCommandFactory(repository, this.bulkContentCommandFactory(repository));
    }

    @Nonnull
    public ScmCommandFactory getCommandFactory(@Nonnull Repository repository) {
        return new PluginScmCommandFactory(repository, this.findByRepository(repository).getCommandFactory());
    }

    @Nonnull
    public ScmCompareCommandFactory getCompareCommandFactory(@Nonnull CompareRequest compareRequest) {
        return new PluginScmCompareCommandFactory(compareRequest, this.compareCommandFactory(compareRequest));
    }

    @Nullable
    public ScmLatch getCurrentLatch() {
        return this.isLatched() ? this.latch : null;
    }

    @Nonnull
    public ScmHookHandlerFactory getHookHandlerFactory(@Nonnull Repository repository) {
        return new PluginScmHookHandlerFactory(repository, this.hookHandlerFactory(repository));
    }

    @Nonnull
    public ScmMirrorCommandFactory getMirrorCommandFactory(@Nonnull Repository repository) {
        return new PluginScmMirrorCommandFactory(repository, this.mirrorCommandFactory(repository));
    }

    @Nonnull
    public Set<ScmProtocol> getProtocols(@Nonnull Repository repository) {
        Scm scm = this.findById(repository.getScmId());
        ImmutableSet.Builder builder = ImmutableSet.builder();
        this.getEnabledProtocols().filter(scmProtocol -> scmProtocol.supports(scm)).forEach(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
        return builder.build();
    }

    @Nonnull
    public ScmPullRequestCommandFactory getPullRequestCommandFactory(@Nonnull PullRequest pullRequest) {
        return new PluginScmPullRequestCommandFactory(pullRequest, this.pullRequestCommandFactory(pullRequest));
    }

    @Nonnull
    public ScmRefCommandFactory getRefCommandFactory(@Nonnull Repository repository) {
        return new PluginScmRefCommandFactory(repository, this.refCommandFactory(repository));
    }

    @Nonnull
    public String getScmName(@Nonnull Repository repository) {
        return this.findByRepository(repository).getName();
    }

    public long getSize(@Nonnull Repository repository) {
        return this.findByRepository(repository).getSize(repository);
    }

    @Nonnull
    public LatchState getState() {
        ScmLatch scmLatch = this.getCurrentLatch();
        if (scmLatch == null) {
            return LatchState.AVAILABLE;
        }
        if (scmLatch.drain(0L, TimeUnit.NANOSECONDS)) {
            return LatchState.DRAINED;
        }
        return LatchState.LATCHED;
    }

    public boolean isEmpty(@Nonnull Repository repository) {
        return this.findByRepository(repository).isEmpty(repository);
    }

    public boolean isLatched() {
        DefaultScmLatch current = this.latch;
        return current != null && current.isAcquired();
    }

    @NotProfiled
    public boolean isSupported(@Nonnull Repository repository, @Nonnull ScmFeature feature) {
        return this.findByRepository(repository).getFeatures().contains(Preconditions.checkNotNull((Object)feature, (Object)"feature"));
    }

    @NotProfiled
    public boolean isSupported(@Nonnull String scmId, @Nonnull ScmFeature feature) {
        return this.findById(scmId).getFeatures().contains(Preconditions.checkNotNull((Object)feature, (Object)"feature"));
    }

    @EventListener
    public void onBeforePluginDisabled(BeforePluginDisabledEvent event) {
        Plugin plugin = event.getPlugin();
        log.debug("Plugin {} is being disabled; checking for SCMs", (Object)plugin.getKey());
        this.invalidateCacheForDisabledScms(plugin);
    }

    @EventListener
    public void onNodeAdded(ClusterNodeAddedEvent event) {
        DefaultScmLatch current = this.latch;
        if (current != null) {
            current.onNodeJoined(event.getAddedNode());
        }
    }

    @EventListener
    public void onPluginFrameworkStarted(PluginFrameworkStartedEvent ignored) {
        this.checkGitStatus();
    }

    @EventListener
    public void onStatusChanged(ScmStatusChangedEvent event) {
        Scm scm = event.getScm();
        log.debug("Invaliding cached Scm for SCM {} after status change", (Object)scm.getId());
        this.cache.invalidate((Object)scm.getId());
        if (SCM_GIT.equals(scm.getId())) {
            this.checkGitStatus();
        }
    }

    public void rescope(@Nonnull RepositoryRescopeCommandParameters parameters) {
        this.pullRequestCommandFactory(((RepositoryRescopeCommandParameters)Preconditions.checkNotNull((Object)parameters, (Object)"parameters")).getRepository()).rescope(parameters).call();
    }

    public void setBeanName(String name) {
        this.beanName = name;
    }

    @Nonnull
    private PluginBulkContentCommandFactory bulkContentCommandFactory(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginBulkContentCommandFactory commandFactory = scm.getBulkContentCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.BULK_CONTENT);
        }
        return commandFactory;
    }

    private void checkGitStatus() {
        try {
            Scm scm = this.findById(SCM_GIT);
            KeyedMessage statusMessage = scm.getStatus().getMessage();
            if (statusMessage != null) {
                log.info(statusMessage.getRootMessage());
            }
        }
        catch (UnavailableScmException e) {
            String localisedMessage = e.getLocalizedMessage();
            log.error(STARS);
            log.error(localisedMessage);
            log.error(STARS);
            Event johnsonEvent = new Event(EventType.get((String)"plugin-failed"), localisedMessage, EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
        catch (UnsupportedScmTypeException e) {
            log.error(STARS);
            log.error(e.getLocalizedMessage());
            log.error(STARS);
            Event johnsonEvent = new Event(EventType.get((String)"plugin-failed"), this.i18nService.getMessage("bitbucket.plugin.failed", new Object[]{"Git SCM Plugin"}), EventLevel.get((String)"error"));
            this.eventPublisher.publish((Object)new AddEvent((Object)this, johnsonEvent));
        }
    }

    @Nonnull
    private PluginCompareCommandFactory compareCommandFactory(@Nonnull CompareRequest compareRequest) {
        Repository repository = ((CompareRequest)Preconditions.checkNotNull((Object)compareRequest, (Object)"compareRequest")).getToRef().getRepository();
        Scm scm = this.findByRepository(repository);
        PluginCompareCommandFactory commandFactory = scm.getCompareCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.COMPARE);
        }
        return commandFactory;
    }

    private <T, D extends ModuleDescriptor<T>> Collection<D> getEnabledModuleDescriptors(Class<D> descriptorClass) {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(descriptorClass);
    }

    private Stream<ScmProtocol> getEnabledProtocols() {
        return ModuleDescriptorUtils.toModules(this.getEnabledModuleDescriptors(ScmProtocolModuleDescriptor.class).stream());
    }

    private Stream<Scm> getEnabledScms() {
        return ModuleDescriptorUtils.toSortedModules(this.getEnabledModuleDescriptors(ScmModuleDescriptor.class).stream());
    }

    private FeatureUnsupportedScmException featureUnsupported(String scmId, ScmFeature feature) {
        throw new FeatureUnsupportedScmException(this.i18nService.createKeyedMessage("bitbucket.scm.feature.unsupported", new Object[]{scmId, feature}), scmId, feature);
    }

    @Nonnull
    private PluginHookHandlerFactory hookHandlerFactory(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginHookHandlerFactory handlerFactory = scm.getHookHandlerFactory();
        if (handlerFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.HOOKS);
        }
        return handlerFactory;
    }

    private void invalidateCacheForDisabledScms(Plugin plugin) {
        List descriptors = plugin.getModuleDescriptorsByModuleClass(Scm.class);
        if (CollectionUtils.isEmpty((Collection)descriptors)) {
            log.debug("Plugin {} did not provide any SCMs", (Object)plugin.getKey());
        } else {
            log.debug("Plugin {} provided {} SCM(s); removing from cache if present", (Object)plugin.getKey(), (Object)descriptors.size());
            for (ModuleDescriptor descriptor : descriptors) {
                Scm scm = (Scm)descriptor.getModule();
                log.debug("Invalidating cached Scm for SCM {} after disabling", (Object)scm.getId());
                this.cache.invalidate((Object)scm.getId());
            }
        }
    }

    @Nonnull
    private PluginMirrorCommandFactory mirrorCommandFactory(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginMirrorCommandFactory commandFactory = scm.getMirrorCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.MIRRORS);
        }
        return commandFactory;
    }

    @Nonnull
    private PluginPullRequestCommandFactory pullRequestCommandFactory(@Nonnull PullRequest pullRequest) {
        return this.pullRequestCommandFactory(((PullRequest)Preconditions.checkNotNull((Object)pullRequest, (Object)"pullRequest")).getToRef().getRepository());
    }

    @Nonnull
    private PluginPullRequestCommandFactory pullRequestCommandFactory(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginPullRequestCommandFactory commandFactory = scm.getPullRequestCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.PULL_REQUESTS);
        }
        return commandFactory;
    }

    @Nonnull
    private PluginRefCommandFactory refCommandFactory(@Nonnull Repository repository) {
        Scm scm = this.findByRepository(repository);
        PluginRefCommandFactory commandFactory = scm.getRefCommandFactory();
        if (commandFactory == null) {
            throw this.featureUnsupported(repository.getScmId(), ScmFeature.REFS);
        }
        return commandFactory;
    }

    private UnavailableScmException unavailableScm(String scmId, KeyedMessage statusMessage) {
        throw new UnavailableScmException(statusMessage, scmId);
    }

    private UnsupportedScmException unsupportedScm(String scmId) {
        throw new UnsupportedScmException(this.i18nService.createKeyedMessage("bitbucket.scm.unsupported", new Object[]{scmId}), scmId);
    }

    private class DefaultScmLatch
    extends ClusterableLatch
    implements ScmLatch {
        public DefaultScmLatch(LatchMode mode) {
            super(mode, PluginScmService.this.cluster, PluginScmService.this.executorService, PluginScmService.this.beanName);
        }

        @Override
        protected void acquireLocally() {
        }

        @Override
        protected boolean drainLocally(long timeout, @Nonnull TimeUnit unit, boolean force) {
            Preconditions.checkArgument((timeout >= 0L ? 1 : 0) != 0, (Object)"timeout must be non-negative");
            Preconditions.checkNotNull((Object)((Object)unit), (Object)"unit");
            this.ensureInitiator();
            long timeoutNs = unit.toNanos(timeout);
            AtomicLong remainingNs = new AtomicLong(Math.max(0L, timeoutNs));
            log.debug("Draining SCMs with timeout of {}ms", (Object)unit.toMillis(timeout));
            return this.getDrainableScms().allMatch(scm -> {
                log.debug("Draining SCM {}", scm);
                try (Timer ignored = TimerUtils.start((String)("Draining SCM " + scm));){
                    boolean drained;
                    long remaining = remainingNs.get();
                    long startNs = System.nanoTime();
                    boolean bl = drained = force && scm instanceof ForcedDrainable ? ((ForcedDrainable)scm).forceDrain(remaining, TimeUnit.NANOSECONDS) : ((Drainable)scm).drain(remaining, TimeUnit.NANOSECONDS);
                    if (!drained) {
                        log.warn("Failed to drain SCM {} in remaining allocated time ({}ms) of total ({}ms)", new Object[]{scm, TimeUnit.NANOSECONDS.toMillis(remaining), unit.toMillis(timeout)});
                        boolean bl2 = false;
                        return bl2;
                    }
                    remainingNs.set(Math.max(0L, remaining - (System.nanoTime() - startNs)));
                }
                return true;
            });
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void unlatchLocally() {
            this.ensureInitiator();
            String string = PluginScmService.SCM_GIT;
            synchronized (PluginScmService.SCM_GIT) {
                PluginScmService.this.latch = null;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }

        private void ensureInitiator() {
            Preconditions.checkState((PluginScmService.this.latch == this ? 1 : 0) != 0, (Object)"This latch is no longer active");
        }

        private Stream<Scm> getDrainableScms() {
            return PluginScmService.this.getEnabledScms().filter(scm -> scm instanceof Drainable).filter(IS_AVAILABLE);
        }
    }
}

