/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.scm;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.commit.graph.TraversalCallback;
import com.atlassian.bitbucket.content.Blame;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.content.ContentTreeCallback;
import com.atlassian.bitbucket.content.ContentTreeNode;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.FileContentCallback;
import com.atlassian.bitbucket.io.TypeAwareOutputSupplier;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.repository.TagCallback;
import com.atlassian.bitbucket.scm.BlameCommandParameters;
import com.atlassian.bitbucket.scm.BranchesCommandParameters;
import com.atlassian.bitbucket.scm.ChangesCommandParameters;
import com.atlassian.bitbucket.scm.ChangesetsCommandParameters;
import com.atlassian.bitbucket.scm.Command;
import com.atlassian.bitbucket.scm.CommitCommandParameters;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.DiffCommandParameters;
import com.atlassian.bitbucket.scm.DirectoryCommandParameters;
import com.atlassian.bitbucket.scm.FileCommandParameters;
import com.atlassian.bitbucket.scm.MergeCommandParameters;
import com.atlassian.bitbucket.scm.PluginCommandFactory;
import com.atlassian.bitbucket.scm.RawFileCommandParameters;
import com.atlassian.bitbucket.scm.ResolveRefsCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.TagsCommandParameters;
import com.atlassian.bitbucket.scm.TypeCommandParameters;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;

public class PluginScmCommandFactory
implements ScmCommandFactory {
    private final PluginCommandFactory commandFactory;
    private final Repository repository;

    public PluginScmCommandFactory(Repository repository, PluginCommandFactory commandFactory) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.commandFactory = Objects.requireNonNull(commandFactory, "commandFactory");
    }

    @Nonnull
    public Command<List<Blame>> blame(@Nonnull BlameCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.blame(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Page<Branch>> branches(@Nonnull BranchesCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.branches(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Void> changes(@Nonnull ChangesCommandParameters parameters, @Nonnull ChangeCallback callback) {
        return this.commandFactory.changes(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Page<Change>> changes(@Nonnull ChangesCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.changes(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Page<Changeset>> changesets(@Nonnull ChangesetsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.changesets(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Commit> commit(@Nonnull CommitCommandParameters parameters) {
        return this.commandFactory.commit(this.repository, parameters);
    }

    @Nonnull
    public Command<Page<Commit>> commits(@Nonnull CommitsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.commits(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Void> commits(@Nonnull CommitsCommandParameters parameters, @Nonnull CommitCallback callback) {
        return this.commandFactory.commits(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Void> create() {
        return this.commandFactory.create(this.repository);
    }

    @Nonnull
    public Command<Branch> defaultBranch() {
        return this.commandFactory.defaultBranch(this.repository);
    }

    @Nonnull
    public Command<Void> diff(@Nonnull DiffCommandParameters parameters, @Nonnull DiffContentCallback callback) {
        return this.commandFactory.diff(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Void> directory(@Nonnull DirectoryCommandParameters parameters, @Nonnull ContentTreeCallback callback, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.directory(this.repository, parameters, callback, pageRequest);
    }

    @Nonnull
    public Command<Void> file(@Nonnull FileCommandParameters parameters, @Nonnull FileContentCallback callback, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.file(this.repository, parameters, callback, pageRequest);
    }

    @Nonnull
    public Command<Void> fork(@Nonnull Repository fork) {
        return this.commandFactory.fork(this.repository, fork);
    }

    @Nonnull
    public Command<Void> heads(@Nonnull RefCallback callback) {
        return this.commandFactory.heads(this.repository, callback);
    }

    @Nonnull
    public Command<Branch> merge(@Nonnull MergeCommandParameters parameters) {
        return this.commandFactory.merge(this.repository, parameters);
    }

    @Nonnull
    public Command<Void> rawFile(@Nonnull RawFileCommandParameters parameters, @Nonnull TypeAwareOutputSupplier outputSupplier) {
        return this.commandFactory.rawFile(this.repository, parameters, outputSupplier);
    }

    @Nonnull
    public Command<Ref> resolveRef(@Nonnull String refId) {
        return this.commandFactory.resolveRef(this.repository, refId);
    }

    @Nonnull
    public Command<Map<String, Ref>> resolveRefs(@Nonnull ResolveRefsCommandParameters parameters) {
        return this.commandFactory.resolveRefs(this.repository, parameters);
    }

    @Nonnull
    public Command<Page<Tag>> tags(@Nonnull TagsCommandParameters parameters, @Nonnull PageRequest pageRequest) {
        return this.commandFactory.tags(this.repository, parameters, pageRequest);
    }

    @Nonnull
    public Command<Void> tags(@Nonnull TagsCommandParameters parameters, @Nonnull TagCallback callback) {
        return this.commandFactory.tags(this.repository, parameters, callback);
    }

    @Nonnull
    public Command<Void> traverseCommits(@Nonnull TraversalCallback callback) {
        return this.commandFactory.traverseCommits(this.repository, callback);
    }

    @Nonnull
    public Command<ContentTreeNode.Type> type(@Nonnull TypeCommandParameters parameters) {
        return this.commandFactory.type(this.repository, parameters);
    }

    @Nonnull
    public Command<Void> updateDefaultBranch(@Nonnull String branchName) throws IllegalArgumentException, UnsupportedOperationException {
        return this.commandFactory.updateDefaultBranch(this.repository, branchName);
    }
}

