/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.request;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.experimental.request.ExperimentalRequestContext;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.google.common.base.Preconditions;
import java.time.Duration;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component(value="requestContext")
@AvailableToPlugins(value=RequestContext.class)
public class CurrentRequestContext
implements ApplicationListener<ContextRefreshedEvent>,
ExperimentalRequestContext {
    private final AuthenticationContext authenticationContext;
    private RequestManager requestManager;

    @Autowired
    public CurrentRequestContext(AuthenticationContext authenticationContext) {
        this.authenticationContext = authenticationContext;
    }

    public void addCleanupCallback(@Nonnull Runnable callback) {
        this.current().addCleanupCallback((Runnable)Preconditions.checkNotNull((Object)callback, (Object)"callback"));
    }

    public void addLabel(@Nonnull String label) {
        this.current().addLabel(label);
    }

    @Nonnull
    public Optional<ApplicationUser> getAuthenticatedUser() {
        return this.current().getAuthenticatedUser();
    }

    @Nonnull
    public AuthenticationContext getAuthenticationContext() {
        return this.authenticationContext;
    }

    @Nonnull
    public String getAction() {
        return this.current().getAction();
    }

    @Nullable
    public String getDetails() {
        return this.current().getDetails();
    }

    @Nonnull
    public String getId() {
        return this.current().getId();
    }

    @Nonnull
    public String getProtocol() {
        return this.current().getProtocol();
    }

    @Nonnull
    public Object getRawRequest() {
        return this.current().getRawRequest();
    }

    @Nonnull
    public Object getRawResponse() {
        return this.current().getRawResponse();
    }

    @Nullable
    public String getRemoteAddress() {
        return this.current().getRemoteAddress();
    }

    @Nullable
    public String getSessionId() {
        return this.current().getSessionId();
    }

    public boolean hasSessionId() {
        return this.current().hasSessionId();
    }

    public boolean isActive() {
        return this.requestManager != null && this.requestManager.getRequestContext() != null;
    }

    public void setAuthenticatedUser(@Nonnull ApplicationUser user) {
        this.current().setAuthenticatedUser(user);
    }

    public long getBytesRead() {
        return this.current().getBytesRead();
    }

    public void setBytesRead(long bytesRead) {
        this.current().setBytesRead(bytesRead);
    }

    public long getBytesWritten() {
        return this.current().getBytesWritten();
    }

    public void setBytesWritten(long bytesWritten) {
        this.current().setBytesWritten(bytesWritten);
    }

    @Nonnull
    public Optional<Duration> getDuration() {
        return this.current().getDuration();
    }

    public void setResponseCode(int responseCode) {
        this.current().setResponseCode(responseCode);
    }

    public boolean isSecure() {
        return this.current().isSecure();
    }

    public void onApplicationEvent(ContextRefreshedEvent event) {
        this.requestManager = (RequestManager)event.getApplicationContext().getBean(RequestManager.class);
    }

    private ExperimentalRequestContext current() {
        ExperimentalRequestContext context = (ExperimentalRequestContext)this.requestManager.getRequestContext();
        Preconditions.checkState((context != null ? 1 : 0) != 0, (Object)"There is no current RequestContext");
        return context;
    }
}

