/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.commit.AbstractCommitCallback;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandUsageException;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestRescopeActivity;
import com.atlassian.stash.internal.pull.InternalRescopeDetails;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetails;
import com.atlassian.stash.internal.pull.rescope.InternalRescopeActivityDetailsProvider;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="pullRequestRescopeActivityDetailsProvider")
public class DefaultRescopeActivityDetailsProvider
implements InternalRescopeActivityDetailsProvider {
    private static final Comparator<Commit> DATE_COMPARATOR = new Comparator<Commit>(){

        @Override
        public int compare(Commit left, Commit right) {
            return right.getAuthorTimestamp().compareTo(left.getAuthorTimestamp());
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DefaultRescopeActivityDetailsProvider.class);
    private final int displayCommits;
    private final int maxCommits;
    private final ScmService scmService;

    @Autowired
    public DefaultRescopeActivityDetailsProvider(ScmService scmService, @Value(value="${pullrequest.rescope.commits.display}") int displayCommits, @Value(value="${pullrequest.rescope.commits.max}") int maxCommits) {
        this.displayCommits = displayCommits;
        this.maxCommits = maxCommits;
        this.scmService = scmService;
    }

    @Nonnull
    public InternalRescopeActivityDetails getDetails(@Nonnull InternalPullRequestRescopeActivity activity) {
        InternalPullRequest pullRequest = activity.getPullRequest();
        InternalRepository repository = pullRequest.getScopeRepository();
        InternalRepository secondaryRepository = pullRequest.isCrossRepository() ? pullRequest.getFromRef().getRepository() : null;
        HashMap<String, Commit> cache = new HashMap<String, Commit>(this.maxCommits);
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory((Repository)repository);
        Set<String> current = this.getCommitsBetween(commandFactory, activity.getToHash(), activity.getFromHash(), secondaryRepository, cache);
        Set<String> previous = this.getCommitsBetween(commandFactory, activity.getPreviousToHash(), activity.getPreviousFromHash(), secondaryRepository, cache);
        return new InternalRescopeActivityDetails(this.toRescopeDetails(current, previous, cache), this.toRescopeDetails(previous, current, cache));
    }

    private Set<String> getCommitsBetween(ScmCommandFactory commandFactory, String untilId, String sinceId, InternalRepository secondaryRepository, Map<String, Commit> cache) {
        MappingCommitCallback currentCallback = new MappingCommitCallback(cache, this.maxCommits);
        try {
            commandFactory.commits(new CommitsCommandParameters.Builder().include(sinceId, new String[0]).exclude(untilId, new String[0]).secondaryRepository((Repository)secondaryRepository).build(), (CommitCallback)currentCallback).call();
        }
        catch (CommandUsageException e) {
            log.warn("Commits between {} and {} could not be calculated; both commits no longer exist", (Object)sinceId, (Object)untilId);
        }
        return currentCallback.getCommitIds();
    }

    private InternalRescopeDetails toRescopeDetails(Set<String> include, Set<String> exclude, Map<String, Commit> cache) {
        HashSet difference = Sets.newHashSet(include);
        difference.removeAll(exclude);
        if (difference.isEmpty()) {
            return InternalRescopeDetails.EMPTY;
        }
        List commits = Lists.newArrayListWithCapacity((int)difference.size());
        for (String commitId : difference) {
            Commit commit = cache.get(commitId);
            if (commit == null) continue;
            commits.add(commit);
        }
        Collections.sort(commits, DATE_COMPARATOR);
        if (commits.size() > this.displayCommits) {
            commits = commits.subList(0, this.displayCommits);
        }
        return new InternalRescopeDetails.Builder().commits((Iterable)commits).total(difference.size()).build();
    }

    private static class MappingCommitCallback
    extends AbstractCommitCallback {
        private final Map<String, Commit> cache;
        private final Set<String> commitIds;
        private final int maxCommits;

        private MappingCommitCallback(Map<String, Commit> cache, int maxCommits) {
            this.cache = cache;
            this.maxCommits = maxCommits;
            this.commitIds = Sets.newHashSet();
        }

        public Set<String> getCommitIds() {
            return this.commitIds;
        }

        public boolean onCommit(@Nonnull Commit commit) {
            String commitId = commit.getId();
            if (this.cache.size() < this.maxCommits) {
                this.cache.put(commitId, commit);
            }
            this.commitIds.add(commitId);
            return true;
        }
    }
}

