/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.drift;

import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ChangesCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.PullRequestEffectiveDiff;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestDiffCommentAnchor;
import com.atlassian.stash.internal.pull.comment.drift.CommentDriftStrategy;
import com.atlassian.stash.internal.pull.comment.drift.DriftContext;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.Ordered;
import org.springframework.stereotype.Component;

@Component
public class FastForwardCommentDriftStrategy
implements CommentDriftStrategy,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(FastForwardCommentDriftStrategy.class);
    private final ScmService scmService;
    @Value(value="${page.max.changes}")
    private int maxChanges;

    @Autowired
    public FastForwardCommentDriftStrategy(ScmService scmService) {
        this.scmService = scmService;
    }

    @Override
    public void apply(@Nonnull DriftContext context) {
        Set<String> retainedPaths = this.calculateRetainedPaths(context);
        if (retainedPaths.isEmpty()) {
            log.debug("{}: No anchors could be fast-forwarded", (Object)context.getPullRequest().getGlobalId());
            return;
        }
        Iterator<InternalPullRequestDiffCommentAnchor> iterator = context.iterator();
        while (iterator.hasNext()) {
            InternalPullRequestDiffCommentAnchor anchor = iterator.next();
            if (!this.isRetained(retainedPaths, anchor)) continue;
            context.retain(anchor);
            iterator.remove();
        }
    }

    @Override
    public String getName() {
        return "FastForward";
    }

    public int getOrder() {
        return -10;
    }

    @Nonnull
    private Set<String> calculateRetainedPaths(DriftContext context) {
        Throwable throwable;
        Timer ignored;
        String timerName;
        String fromHash;
        Set<String> retainedPaths = this.extractCommentedPaths(context);
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory((Repository)context.getRepository());
        InternalPullRequest pullRequest = context.getPullRequest();
        String previousFromHash = context.getPreviousFromHash();
        if (previousFromHash.equals(fromHash = pullRequest.getFromRef().getLatestCommit())) {
            log.debug("{}: The source branch has not been updated and will not be checked for changes", (Object)pullRequest.getGlobalId());
        } else {
            PullRequestEffectiveDiff previousDiff = context.getPreviousDiff();
            PullRequestEffectiveDiff currentDiff = context.getCurrentDiff();
            timerName = "Drift: " + this.getName() + " - Merge changes [" + previousDiff.getUntilId() + "]->[" + currentDiff.getUntilId() + "] " + pullRequest.getGlobalId();
            ignored = TimerUtils.start((String)timerName);
            throwable = null;
            try {
                this.excludeUpdatedPaths(commandFactory, retainedPaths, currentDiff.getUntilId(), previousDiff.getUntilId());
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
            if (retainedPaths.isEmpty()) {
                return Collections.emptySet();
            }
        }
        String previousToHash = context.getPreviousToHash();
        String toHash = pullRequest.getToRef().getLatestCommit();
        if (previousToHash.equals(toHash)) {
            log.debug("{}: The target branch has not been updated and will not be checked for changes", (Object)pullRequest.getGlobalId());
        } else {
            timerName = "Drift: " + this.getName() + " - Target changes [" + previousToHash + "]->[" + toHash + "] " + pullRequest.getGlobalId();
            ignored = TimerUtils.start((String)timerName);
            throwable = null;
            try {
                this.excludeUpdatedPaths(commandFactory, retainedPaths, toHash, previousToHash);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (ignored != null) {
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable5) {
                            throwable.addSuppressed(throwable5);
                        }
                    } else {
                        ignored.close();
                    }
                }
            }
        }
        return retainedPaths;
    }

    private void excludeUpdatedPaths(ScmCommandFactory commandFactory, Set<String> retainedPaths, String untilId, String sinceId) {
        PageRequest pageRequest = PageUtils.newRequest((int)0, (int)this.maxChanges);
        ChangesCommandParameters parameters = new ChangesCommandParameters.Builder().sinceId(sinceId).untilId(untilId).build();
        Page changes = (Page)commandFactory.changes(parameters, pageRequest).call();
        if (changes != null) {
            for (Change change : changes.getValues()) {
                retainedPaths.remove(change.getPath().toString());
                Path srcPath = change.getSrcPath();
                if (srcPath == null) continue;
                retainedPaths.remove(srcPath.toString());
            }
        }
    }

    @Nonnull
    private Set<String> extractCommentedPaths(DriftContext context) {
        HashSet paths = Sets.newHashSet();
        for (InternalPullRequestDiffCommentAnchor anchor : context) {
            paths.add(anchor.getPath());
            String srcPath = anchor.getSrcPath();
            if (srcPath == null) continue;
            paths.add(srcPath);
        }
        return paths;
    }

    private boolean isRetained(Set<String> retainedPaths, InternalPullRequestDiffCommentAnchor anchor) {
        return retainedPaths.contains(anchor.getPath()) && (anchor.getSrcPath() == null || retainedPaths.contains(anchor.getSrcPath()));
    }
}

