/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.comment.diff;

import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffLine;
import com.atlassian.bitbucket.content.DiffSegmentType;
import com.atlassian.bitbucket.content.SimpleDiffLine;
import com.atlassian.bitbucket.content.SimpleDiffSegment;
import com.atlassian.fugue.Option;
import com.atlassian.stash.internal.comment.InternalDiffCommentAnchor;
import com.atlassian.stash.internal.content.DiffLineCallback;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;

public class DiffContextLine {
    public static final DiffLineCallback<DiffContextLine> FACTORY_CALLBACK = new DiffLineCallback<DiffContextLine>(){

        @Override
        @Nonnull
        public DiffContextLine onLine(DiffSegmentType segmentType, int source, int destination, String line, ConflictMarker marker, boolean truncated) {
            return new DiffContextLine(segmentType, source, destination, line, marker, truncated);
        }
    };
    private final Option<Long> commentId;
    private final int commentLine;
    private final ConflictMarker conflictMarker;
    private final int destination;
    private final String line;
    private final int source;
    private final boolean truncated;
    private final DiffSegmentType type;

    public DiffContextLine(@Nonnull DiffSegmentType type, int source, int destination, String line, ConflictMarker marker, boolean truncated) {
        this(type, source, destination, line, marker, truncated, (Option<Long>)Option.none(Long.class));
    }

    private DiffContextLine(@Nonnull DiffSegmentType type, int source, int destination, String line, ConflictMarker marker, boolean truncated, @Nonnull Option<Long> commentId) {
        this.commentId = commentId;
        this.destination = destination;
        this.line = line;
        this.source = source;
        this.truncated = truncated;
        this.type = (DiffSegmentType)Preconditions.checkNotNull((Object)type, (Object)"type");
        this.commentLine = type == DiffSegmentType.ADDED ? destination : source;
        this.conflictMarker = marker;
    }

    public void addToSegment(SimpleDiffSegment.Builder segmentBuilder) {
        segmentBuilder.line((DiffLine)this.newDiffLine());
    }

    public int getDestination() {
        return this.destination;
    }

    public int getSource() {
        return this.source;
    }

    @Nonnull
    public DiffSegmentType getType() {
        return this.type;
    }

    public boolean isAnchor(InternalDiffCommentAnchor anchor) {
        return this.type == anchor.getLineType() && this.commentLine == anchor.getLine();
    }

    @Nonnull
    public SimpleDiffSegment.Builder startNewSegment() {
        return new SimpleDiffSegment.Builder().line((DiffLine)this.newDiffLine()).type(this.type);
    }

    @Nonnull
    public DiffContextLine withComment(long id) {
        if (this.commentId.isEmpty()) {
            return new DiffContextLine(this.type, this.source, this.destination, this.line, this.conflictMarker, this.truncated, (Option<Long>)Option.some((Object)id));
        }
        throw new IllegalStateException("This DiffContextLine already references comment " + this.commentId.get());
    }

    @Nonnull
    private SimpleDiffLine newDiffLine() {
        SimpleDiffLine.Builder builder = new SimpleDiffLine.Builder().conflictMarker(this.conflictMarker).destination(this.destination).line(this.line).source(this.source).truncated(this.truncated);
        for (Long id : this.commentId) {
            builder.commentId(id.longValue());
        }
        return builder.build();
    }
}

