/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.auth.AuthenticationContext;
import com.atlassian.bitbucket.event.pull.PullRequestActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestApprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantApprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantReviewedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantUnapprovedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantsUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedActivityEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUnapprovedEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.IllegalPullRequestStateException;
import com.atlassian.bitbucket.pull.InvalidPullRequestParticipantException;
import com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException;
import com.atlassian.bitbucket.pull.InvalidPullRequestRoleException;
import com.atlassian.bitbucket.pull.NoSuchParticipantException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.PullRequestActivity;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantSearchRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.pull.PullRequestReviewersUpdatedActivity;
import com.atlassian.bitbucket.pull.PullRequestRole;
import com.atlassian.bitbucket.pull.UnmodifiablePullRequestRoleException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.bitbucket.util.UserUtils;
import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.InternalPullRequestActivity;
import com.atlassian.stash.internal.pull.InternalPullRequestParticipant;
import com.atlassian.stash.internal.pull.InternalPullRequestReviewersUpdatedActivity;
import com.atlassian.stash.internal.pull.PullRequestActivityDao;
import com.atlassian.stash.internal.pull.PullRequestParticipantDao;
import com.atlassian.stash.internal.pull.PullRequestParticipantSearchCriteria;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.atlassian.stash.internal.user.InternalApplicationUser;
import com.atlassian.stash.internal.util.InternalPageUtils;
import com.atlassian.stash.internal.watcher.InternalWatchable;
import com.atlassian.stash.internal.watcher.InternalWatcherService;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

@Component(value="pullRequestParticipantHelper")
public class InternalPullRequestParticipantHelper {
    private final PullRequestActivityDao activityDao;
    private final AuthenticationContext authenticationContext;
    private final EventPublisher eventPublisher;
    private final I18nService i18nService;
    private final PullRequestParticipantDao participantDao;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final TransactionTemplate transactionTemplate;
    private final UserService userService;
    private final InternalWatcherService watcherService;
    @Value(value="${page.max.users}")
    private int maxUserPageSize;

    @Autowired
    public InternalPullRequestParticipantHelper(PullRequestActivityDao activityDao, AuthenticationContext authenticationContext, EventPublisher eventPublisher, I18nService i18nService, PullRequestParticipantDao participantDao, PermissionService permissionService, PermissionValidationService permissionValidationService, PlatformTransactionManager transactionManager, UserService userService, InternalWatcherService watcherService) {
        this.activityDao = activityDao;
        this.authenticationContext = authenticationContext;
        this.eventPublisher = eventPublisher;
        this.i18nService = i18nService;
        this.participantDao = participantDao;
        this.permissionValidationService = permissionValidationService;
        this.permissionService = permissionService;
        this.transactionTemplate = new TransactionTemplate(transactionManager, SpringTransactionUtils.REQUIRES_NEW);
        this.userService = userService;
        this.watcherService = watcherService;
    }

    @Nonnull
    public InternalPullRequestParticipant addReviewer(@Nonnull InternalPullRequest pullRequest, @Nonnull ApplicationUser user) {
        this.checkAccess(user, pullRequest);
        this.checkCanUpdateRole(pullRequest);
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId(), user.getId());
        if (participant == null) {
            return this.createReviewer(pullRequest, user);
        }
        if (participant.getRole() == PullRequestRole.AUTHOR) {
            throw new UnmodifiablePullRequestRoleException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.role.assign.unmodifiable", new Object[0]));
        }
        if (participant.getRole() != PullRequestRole.REVIEWER) {
            return this.updateParticipant(participant, Optional.of(PullRequestRole.REVIEWER), Optional.empty());
        }
        return participant;
    }

    public void createParticipants(@Nonnull InternalPullRequest pullRequest, @Nonnull ApplicationUser author, @Nonnull Set<ApplicationUser> reviewers) {
        this.addParticipant(pullRequest, author, PullRequestRole.AUTHOR);
        reviewers.forEach(reviewer -> this.addParticipant(pullRequest, (ApplicationUser)reviewer, PullRequestRole.REVIEWER));
    }

    @Nonnull
    public Page<InternalPullRequestParticipant> getParticipants(@Nonnull InternalPullRequest pullRequest, @Nonnull PageRequest pageRequest) {
        return this.participantDao.findByPullRequest(pullRequest.getGlobalId(), pageRequest);
    }

    @Nonnull
    public InternalPullRequestParticipant makeCurrentUserParticipantAndWatcher(@Nonnull InternalPullRequest pullRequest) {
        InternalApplicationUser user = this.getCurrentUser();
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId(), user.getId());
        return participant == null ? this.makeParticipantAndWatcher(pullRequest, (ApplicationUser)user) : participant;
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent rescopedEvent) {
        InternalPullRequest pullRequest = InternalConverter.convertToInternalPullRequest((PullRequest)rescopedEvent.getPullRequest());
        String currentFromHash = pullRequest.getFromRef().getLatestCommit();
        if (!Objects.equals(rescopedEvent.getPreviousFromHash(), currentFromHash)) {
            this.transactionTemplate.execute(status -> this.participantDao.resetStatusByPullRequest(pullRequest.getGlobalId()));
        }
    }

    public void removeReviewer(@Nonnull InternalPullRequest pullRequest, @Nonnull ApplicationUser user) {
        this.checkCanUpdateRole(pullRequest);
        InternalPullRequestParticipant participant = this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId(), user.getId());
        if (participant != null) {
            boolean hasNotContributed;
            PullRequestRole previousRole = participant.getRole();
            if (previousRole == PullRequestRole.AUTHOR) {
                throw new UnmodifiablePullRequestRoleException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.role.unassign.unmodifiable", new Object[0]));
            }
            boolean bl = hasNotContributed = this.activityDao.countByUser(pullRequest.getGlobalId(), (long)user.getId(), Collections.emptySet(), Collections.singleton(PullRequestAction.RESCOPED)) == 0L;
            if (hasNotContributed) {
                this.removeParticipant(participant);
            } else if (previousRole == PullRequestRole.REVIEWER) {
                this.updateParticipant(participant, Optional.of(PullRequestRole.PARTICIPANT), Optional.empty());
            }
        }
    }

    @Nonnull
    public Set<ApplicationUser> resolveReviewers(@Nonnull Repository targetRepository, @Nonnull Set<String> reviewers) {
        return this.resolveReviewers(reviewers, Collections.emptySet(), targetRepository);
    }

    @Nonnull
    public Page<ApplicationUser> searchUsers(@Nonnull PullRequestParticipantSearchRequest searchRequest, @Nonnull PageRequest pageRequest) {
        searchRequest.getFromRepository().ifPresent(repository -> this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ));
        searchRequest.getToRepository().ifPresent(repository -> this.permissionValidationService.validateForRepository(repository, Permission.REPO_READ));
        pageRequest = pageRequest.buildRestrictedPageRequest(this.maxUserPageSize);
        Optional filter = searchRequest.getFilter();
        if (filter.isPresent()) {
            return InternalPageUtils.filterPages(this.participantPageProvider(searchRequest), this.filterPredicate((String)filter.get()), pageRequest, this.maxUserPageSize * 2);
        }
        return this.participantPageProvider(searchRequest).get(pageRequest);
    }

    public void setReviewers(@Nonnull InternalPullRequest pullRequest, @Nonnull Set<String> newReviewerNames) {
        Set currentReviewers = (Set)pullRequest.getReviewers().stream().map(PullRequestParticipant::getUser).collect(MoreCollectors.toImmutableSet());
        ApplicationUser author = pullRequest.getAuthor().getUser();
        Set<ApplicationUser> newReviewers = this.resolveReviewers((Set)newReviewerNames.stream().filter(reviewer -> !reviewer.equals(author.getName())).collect(MoreCollectors.toImmutableSet()), (Set)pullRequest.getAllParticipants().stream().map(PullRequestParticipant::getUser).collect(MoreCollectors.toImmutableSet()), (Repository)pullRequest.getScopeRepository());
        Sets.SetView addedReviewers = Sets.difference(newReviewers, (Set)currentReviewers);
        Set currentParticipants = (Set)pullRequest.getParticipants().stream().map(PullRequestParticipant::getUser).collect(MoreCollectors.toImmutableSet());
        Sets.SetView currentNonAuthors = Sets.union((Set)currentReviewers, (Set)currentParticipants);
        Sets.SetView removedReviewers = Sets.difference((Set)currentReviewers, newReviewers);
        Sets.SetView addedParticipants = Sets.difference((Set)addedReviewers, (Set)currentNonAuthors);
        Sets.SetView removedParticipants = removedReviewers.isEmpty() ? Collections.emptySet() : Sets.difference((Set)removedReviewers, this.getUsersWithActivities(pullRequest));
        this.updateParticipants(pullRequest, (Set<ApplicationUser>)removedReviewers, (Set<ApplicationUser>)removedParticipants, (Set<ApplicationUser>)addedReviewers, (Set<ApplicationUser>)addedParticipants);
        this.fireReviewersUpdatedEvent(pullRequest, (Set<ApplicationUser>)addedReviewers, (Set<ApplicationUser>)removedReviewers);
        this.fireParticipantsUpdatedEvent(pullRequest, (Set<ApplicationUser>)addedParticipants, (Set<ApplicationUser>)removedParticipants);
        this.logReviewersUpdatedActivity(pullRequest, (Set<ApplicationUser>)addedReviewers, (Set<ApplicationUser>)removedReviewers);
    }

    @Nonnull
    public PullRequestParticipant setStatus(@Nonnull InternalPullRequest pullRequest, @Nonnull PullRequestParticipantStatus status) {
        Objects.requireNonNull(status, "status");
        this.checkCanUpdateStatus(pullRequest);
        InternalApplicationUser currentUser = this.getCurrentUser();
        InternalPullRequestParticipant participant = this.getParticipant(pullRequest, (ApplicationUser)currentUser);
        if (participant == null) {
            if (status == PullRequestParticipantStatus.UNAPPROVED) {
                throw new NoSuchParticipantException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.approve.remove.nosuchparticipant", new Object[]{currentUser.getName()}));
            }
            participant = this.makeParticipantAndWatcher(pullRequest, (ApplicationUser)currentUser);
        }
        if (participant.getRole() == PullRequestRole.AUTHOR) {
            throw new InvalidPullRequestRoleException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.update.participantstatus.author", new Object[0]));
        }
        if (participant.getStatus() != status) {
            participant = this.updateStatus(participant, status);
        }
        return participant;
    }

    private InternalPullRequestParticipant addParticipant(InternalPullRequest pullRequest, ApplicationUser user, PullRequestRole role) {
        InternalPullRequestParticipant participant = (InternalPullRequestParticipant)this.participantDao.create((Object)((InternalPullRequestParticipant.Builder)new InternalPullRequestParticipant.Builder(pullRequest).role(role).user(InternalConverter.convertToInternalUser((ApplicationUser)user))).build());
        this.watcherService.addUserAsWatcher((InternalWatchable)pullRequest, user);
        return participant;
    }

    private void checkAccess(ApplicationUser user, InternalPullRequest pullRequest) {
        this.validateCanAccess(user, (Repository)pullRequest.getScopeRepository()).ifPresent(message -> {
            throw new InvalidPullRequestParticipantException(message, PullRequestRole.REVIEWER);
        });
    }

    private void checkCanUpdateStatus(InternalPullRequest pullRequest) {
        this.checkIsOpen(pullRequest, "bitbucket.service.pullrequest.update.participantstatus.declined", "bitbucket.service.pullrequest.update.participantstatus.merged");
    }

    private void checkCanUpdateRole(InternalPullRequest pullRequest) {
        this.checkIsOpen(pullRequest, "bitbucket.service.pullrequest.roleupdate.declined", "bitbucket.service.pullrequest.roleupdate.merged");
    }

    private void checkIsOpen(InternalPullRequest pullRequest, String declineKey, String mergedKey) {
        switch (pullRequest.getState()) {
            case DECLINED: {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage(declineKey, new Object[0]));
            }
            case MERGED: {
                throw new IllegalPullRequestStateException(this.i18nService.createKeyedMessage(mergedKey, new Object[0]));
            }
        }
    }

    private InternalPullRequestActivity createActivity(InternalPullRequest pullRequest, PullRequestAction action) {
        InternalPullRequestActivity activity = ((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)((InternalPullRequestActivity.Builder)new InternalPullRequestActivity.Builder(pullRequest).action(action)).createdDate(new Date())).user(this.getCurrentUser())).build();
        this.activityDao.create((Object)activity);
        return activity;
    }

    private InternalPullRequestParticipant createReviewer(InternalPullRequest pullRequest, ApplicationUser user) {
        InternalPullRequestParticipant participant = this.addParticipant(pullRequest, user, PullRequestRole.REVIEWER);
        this.fireParticipantsUpdatedEvent(pullRequest, Collections.singleton(user), Collections.emptySet());
        this.fireReviewersUpdatedEvent(pullRequest, Collections.singleton(user), Collections.emptySet());
        this.logReviewersUpdatedActivity(pullRequest, Collections.singleton(user), Collections.emptySet());
        return participant;
    }

    private Predicate<ApplicationUser> filterPredicate(String filter) {
        Pattern pattern = UserUtils.createNameMatchingPattern((String)filter);
        return user -> pattern.matcher(user.getDisplayName()).find() || StringUtils.isNotBlank((CharSequence)user.getEmailAddress()) && pattern.matcher(user.getEmailAddress()).find() || pattern.matcher(user.getName()).find();
    }

    private void fireParticipantsUpdatedEvent(InternalPullRequest pullRequest, Set<ApplicationUser> added, Set<ApplicationUser> removed) {
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.eventPublisher.publish((Object)new PullRequestParticipantsUpdatedEvent((Object)this, (PullRequest)pullRequest, added, removed));
        }
    }

    private void fireReviewersUpdatedEvent(InternalPullRequest pullRequest, Set<ApplicationUser> added, Set<ApplicationUser> removed) {
        if (!added.isEmpty() || !removed.isEmpty()) {
            this.eventPublisher.publish((Object)new PullRequestReviewersUpdatedEvent((Object)this, (PullRequest)pullRequest, added, removed));
        }
    }

    private InternalApplicationUser getCurrentUser() {
        return InternalConverter.convertToInternalUser((ApplicationUser)this.authenticationContext.getCurrentUser());
    }

    private InternalPullRequestParticipant getParticipant(InternalPullRequest pullRequest, ApplicationUser user) {
        return this.participantDao.findByPullRequestAndUser(pullRequest.getGlobalId(), user.getId());
    }

    private Set<InternalApplicationUser> getUsersWithActivities(InternalPullRequest pullRequest) {
        return this.activityDao.findUsersWithActivities(pullRequest.getGlobalId(), Collections.emptySet(), Collections.singleton(PullRequestAction.RESCOPED));
    }

    private void logParticipantStatusActivity(InternalPullRequest pullRequest, PullRequestParticipantStatus previousStatus, PullRequestParticipantStatus currentStatus) {
        if (previousStatus == PullRequestParticipantStatus.NEEDS_WORK && currentStatus == PullRequestParticipantStatus.UNAPPROVED) {
            return;
        }
        InternalPullRequestActivity activity = this.createActivity(pullRequest, InternalPullRequestParticipantHelper.resolveAction(currentStatus));
        this.eventPublisher.publish((Object)new PullRequestActivityEvent((Object)this, (PullRequestActivity)activity));
    }

    private void logReviewersUpdatedActivity(InternalPullRequest pullRequest, Set<ApplicationUser> added, Set<ApplicationUser> removed) {
        if (!added.isEmpty() || !removed.isEmpty()) {
            InternalPullRequestReviewersUpdatedActivity activity = ((InternalPullRequestReviewersUpdatedActivity.Builder)((InternalPullRequestReviewersUpdatedActivity.Builder)new InternalPullRequestReviewersUpdatedActivity.Builder(pullRequest).addedReviewers(added).removedReviewers(removed).createdDate(new Date())).user(this.getCurrentUser())).build();
            this.activityDao.create((Object)activity);
            this.eventPublisher.publish((Object)new PullRequestReviewersUpdatedActivityEvent((Object)this, (PullRequestReviewersUpdatedActivity)activity));
        }
    }

    private InternalPullRequestParticipant makeParticipantAndWatcher(InternalPullRequest pullRequest, ApplicationUser user) {
        InternalPullRequestParticipant participant = this.addParticipant(pullRequest, user, PullRequestRole.PARTICIPANT);
        this.fireParticipantsUpdatedEvent(pullRequest, Collections.singleton(user), Collections.emptySet());
        return participant;
    }

    private PageProvider<ApplicationUser> participantPageProvider(PullRequestParticipantSearchRequest searchRequest) {
        PullRequestParticipantSearchCriteria searchCriteria = new PullRequestParticipantSearchCriteria.Builder(searchRequest).build();
        return request -> PageUtils.asPageOf(ApplicationUser.class, (Page)this.participantDao.searchUsers(searchCriteria, request));
    }

    private void removeParticipant(InternalPullRequestParticipant participant) {
        InternalPullRequest pullRequest = participant.getPullRequest();
        InternalApplicationUser user = participant.getUser();
        this.participantDao.delete((Object)participant);
        this.watcherService.removeUserAsWatcher((InternalWatchable)pullRequest, (ApplicationUser)user);
        this.fireParticipantsUpdatedEvent(pullRequest, Collections.emptySet(), Collections.singleton(user));
        if (PullRequestRole.REVIEWER == participant.getRole()) {
            this.fireReviewersUpdatedEvent(pullRequest, Collections.emptySet(), Collections.singleton(user));
            this.logReviewersUpdatedActivity(pullRequest, Collections.emptySet(), Collections.singleton(user));
        }
    }

    private static PullRequestAction resolveAction(PullRequestParticipantStatus currentStatus) {
        switch (currentStatus) {
            case APPROVED: {
                return PullRequestAction.APPROVED;
            }
            case NEEDS_WORK: {
                return PullRequestAction.REVIEWED;
            }
            case UNAPPROVED: {
                return PullRequestAction.UNAPPROVED;
            }
        }
        return null;
    }

    private Set<ApplicationUser> resolveReviewers(Set<String> reviewers, Set<ApplicationUser> existing, Repository targetRepository) {
        HashMap participantErrors = Maps.newHashMap();
        Map reviewersByName = this.userService.getUsersByName(reviewers, true).stream().collect(Collectors.toMap(Person::getName, Function.identity()));
        HashSet resolvedReviewers = Sets.newHashSet();
        reviewers.forEach(reviewerName -> {
            ApplicationUser reviewer = (ApplicationUser)reviewersByName.get(reviewerName);
            if (reviewer == null || !reviewer.isActive()) {
                participantErrors.put(reviewerName, this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.invalidparticipant", new Object[]{reviewerName}));
            } else if (existing.contains(reviewer)) {
                resolvedReviewers.add(reviewer);
            } else {
                Optional<KeyedMessage> keyedMessage = this.validateCanAccess(reviewer, targetRepository);
                if (keyedMessage.isPresent()) {
                    participantErrors.put(reviewerName, keyedMessage.get());
                } else {
                    resolvedReviewers.add(reviewer);
                }
            }
        });
        if (!participantErrors.isEmpty()) {
            throw new InvalidPullRequestReviewersException(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.invalidparticipants", new Object[0]), (Map)participantErrors, (Set)resolvedReviewers);
        }
        return resolvedReviewers;
    }

    private InternalPullRequestParticipant updateParticipant(InternalPullRequestParticipant participant, Optional<PullRequestRole> role, Optional<PullRequestParticipantStatus> status) {
        PullRequestParticipantStatus previousStatus = participant.getStatus();
        InternalPullRequestParticipant.Builder builder = new InternalPullRequestParticipant.Builder(participant);
        role.ifPresent(arg_0 -> ((InternalPullRequestParticipant.Builder)builder).role(arg_0));
        builder.status(status.orElse(PullRequestParticipantStatus.UNAPPROVED));
        InternalPullRequestParticipant updated = (InternalPullRequestParticipant)this.participantDao.update((Object)builder.build());
        InternalPullRequest pullRequest = updated.getPullRequest();
        role.ifPresent(newRole -> {
            Set<ApplicationUser> removed;
            Set<ApplicationUser> added;
            if (PullRequestRole.REVIEWER == newRole) {
                added = Collections.singleton(participant.getUser());
                removed = Collections.emptySet();
            } else {
                added = Collections.emptySet();
                removed = Collections.singleton(participant.getUser());
            }
            this.fireReviewersUpdatedEvent(participant.getPullRequest(), added, removed);
            this.logReviewersUpdatedActivity(pullRequest, added, removed);
        });
        status.ifPresent(newStatus -> {
            if (newStatus == PullRequestParticipantStatus.NEEDS_WORK) {
                this.eventPublisher.publish((Object)new PullRequestParticipantReviewedEvent((Object)this, (PullRequest)pullRequest, (PullRequestParticipant)updated, previousStatus));
            } else if (newStatus == PullRequestParticipantStatus.APPROVED) {
                this.eventPublisher.publish((Object)new PullRequestApprovedEvent((Object)this, (PullRequestParticipant)updated, (PullRequest)pullRequest));
                this.eventPublisher.publish((Object)new PullRequestParticipantApprovedEvent((Object)this, (PullRequest)pullRequest, (PullRequestParticipant)updated, previousStatus));
            } else if (newStatus == PullRequestParticipantStatus.UNAPPROVED) {
                this.eventPublisher.publish((Object)new PullRequestUnapprovedEvent((Object)this, (PullRequestParticipant)updated, (PullRequest)pullRequest));
                this.eventPublisher.publish((Object)new PullRequestParticipantUnapprovedEvent((Object)this, (PullRequest)pullRequest, (PullRequestParticipant)updated, previousStatus));
            }
            this.logParticipantStatusActivity(pullRequest, previousStatus, (PullRequestParticipantStatus)newStatus);
        });
        return updated;
    }

    private void updateParticipants(InternalPullRequest pullRequest, Set<ApplicationUser> removedReviewers, Set<ApplicationUser> removedReviewersNoLongerParticipating, Set<ApplicationUser> addedReviewers, Set<ApplicationUser> addedReviewersNewlyParticipating) {
        pullRequest.getAllParticipants().forEach(participant -> {
            InternalPullRequestParticipant internal = InternalConverter.convertToInternalParticipant((PullRequestParticipant)participant);
            ApplicationUser user = participant.getUser();
            if (removedReviewersNoLongerParticipating.contains(user)) {
                this.participantDao.delete((Object)internal);
                this.watcherService.removeUserAsWatcher((InternalWatchable)internal.getPullRequest(), (ApplicationUser)internal.getUser());
            } else if (removedReviewers.contains(user)) {
                this.updateRole(internal, PullRequestRole.PARTICIPANT);
            } else if (addedReviewers.contains(user)) {
                this.updateRole(internal, PullRequestRole.REVIEWER);
            }
        });
        addedReviewersNewlyParticipating.forEach(user -> this.addParticipant(pullRequest, (ApplicationUser)user, PullRequestRole.REVIEWER));
    }

    private InternalPullRequestParticipant updateRole(InternalPullRequestParticipant participant, PullRequestRole role) {
        return (InternalPullRequestParticipant)this.participantDao.update((Object)new InternalPullRequestParticipant.Builder(participant).role(role).status(PullRequestParticipantStatus.UNAPPROVED).build());
    }

    private InternalPullRequestParticipant updateStatus(InternalPullRequestParticipant participant, PullRequestParticipantStatus status) {
        Optional<PullRequestRole> role = PullRequestParticipantStatus.UNAPPROVED != status && PullRequestRole.REVIEWER != participant.getRole() ? Optional.of(PullRequestRole.REVIEWER) : Optional.empty();
        return this.updateParticipant(participant, role, Optional.of(status));
    }

    private Optional<KeyedMessage> validateCanAccess(ApplicationUser reviewer, Repository targetRepository) {
        if (!this.permissionService.hasGlobalPermission(reviewer, Permission.LICENSED_USER)) {
            return Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.participant.license", new Object[]{reviewer.getDisplayName()}));
        }
        if (!this.permissionService.hasRepositoryPermission(reviewer, targetRepository, Permission.REPO_READ)) {
            return Optional.of(this.i18nService.createKeyedMessage("bitbucket.service.pullrequest.create.unauthorisedparticipant", new Object[]{reviewer.getDisplayName()}));
        }
        return Optional.empty();
    }
}

