/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestMergeVeto;
import com.atlassian.bitbucket.pull.PullRequestMergeability;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.scm.pull.MergeRequest;
import com.atlassian.bitbucket.scm.pull.MergeRequestCheck;
import com.atlassian.bitbucket.scm.pull.MergeRequestCheckModuleDescriptor;
import com.atlassian.bitbucket.scm.pull.MergeRequestCheckService;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.pull.InternalMergeRequest;
import com.atlassian.stash.internal.pull.InternalMergeRequestCheckService;
import com.atlassian.stash.internal.pull.PullRequestEnricher;
import com.atlassian.stash.internal.pull.SimpleMergeRequest;
import com.atlassian.stash.internal.pull.SimplePullRequestMergeability;
import java.util.Collection;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=MergeRequestCheckService.class)
@Service(value="mergeRequestCheckService")
@Transactional(readOnly=true)
public class DefaultMergeRequestCheckService
implements InternalMergeRequestCheckService {
    private static final Logger log = LoggerFactory.getLogger(DefaultMergeRequestCheckService.class);
    private final PullRequestEnricher enricher;
    private final I18nService i18nService;
    private final PluginAccessor pluginAccessor;
    private final ScmService scmService;

    @Autowired
    public DefaultMergeRequestCheckService(PullRequestEnricher enricher, I18nService i18nService, PluginAccessor pluginAccessor, ScmService scmService) {
        this.enricher = enricher;
        this.i18nService = i18nService;
        this.pluginAccessor = pluginAccessor;
        this.scmService = scmService;
    }

    @Nonnull
    public Collection<PullRequestMergeVeto> check(@Nonnull PullRequest pullRequest) {
        return this.doCheck(new SimpleMergeRequest.Builder(pullRequest).build());
    }

    @Nonnull
    public PullRequestMergeability checkMergeability(@Nonnull InternalMergeRequest mergeRequest) {
        Collection<PullRequestMergeVeto> vetoes = this.doCheck(mergeRequest);
        boolean conflicted = this.isConflicted(mergeRequest.getPullRequest());
        return this.enricher.enrich(InternalConverter.convertToInternalPullRequest((PullRequest)mergeRequest.getPullRequest()), new SimplePullRequestMergeability(vetoes.isEmpty() && !conflicted, conflicted, vetoes));
    }

    private static Timer timer(MergeRequestCheckModuleDescriptor descriptor, MergeRequestCheck module) {
        return TimerUtils.start((String)String.format("Calling merge request check %s of type %s", descriptor.getCompleteKey(), module.getClass().getName()));
    }

    private Collection<PullRequestMergeVeto> doCheck(InternalMergeRequest mergeRequest) {
        for (MergeRequestCheckModuleDescriptor descriptor : this.getDescriptors()) {
            MergeRequestCheck module = descriptor.getModule();
            try {
                Timer ignored = DefaultMergeRequestCheckService.timer(descriptor, module);
                Throwable throwable = null;
                try {
                    module.check((MergeRequest)mergeRequest);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (ignored == null) continue;
                    if (throwable != null) {
                        try {
                            ignored.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ignored.close();
                }
            }
            catch (Exception e) {
                log.warn("Merge request check {} of type {} failed.", new Object[]{descriptor.getCompleteKey(), module.getClass().getName(), e});
                mergeRequest.veto(this.i18nService.getMessage("bitbucket.service.pullrequest.merge.exception.summary", new Object[0]), this.i18nService.getMessage("bitbucket.service.pullrequest.merge.exception.description", new Object[]{descriptor.getPluginKey()}));
            }
        }
        return mergeRequest.getVetoes();
    }

    private Iterable<MergeRequestCheckModuleDescriptor> getDescriptors() {
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(MergeRequestCheckModuleDescriptor.class);
    }

    private boolean isConflicted(PullRequest pullRequest) {
        Boolean canMerge = (Boolean)this.scmService.getPullRequestCommandFactory(pullRequest).canMerge().call();
        return canMerge != null && canMerge == false;
    }
}

