/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.idx;

import com.atlassian.bitbucket.NoSuchResourceException;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.CommitCallback;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.CommitIndexer;
import com.atlassian.bitbucket.idx.CommitIndexingException;
import com.atlassian.bitbucket.idx.IndexingContext;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scm.AsyncCommand;
import com.atlassian.bitbucket.scm.CommitsCommandParameters;
import com.atlassian.bitbucket.scm.ScmCommandFactory;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.util.Chainable;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.UncheckedOperation;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginDisabledEvent;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.idx.BlockingQueueCommitCallback;
import com.atlassian.stash.internal.idx.CommitIndexingService;
import com.atlassian.stash.internal.idx.DefaultIndexingContext;
import com.atlassian.stash.internal.idx.IndexerStateDao;
import com.atlassian.stash.internal.idx.RepositorySnapshotService;
import com.atlassian.stash.internal.repository.InternalRepository;
import com.atlassian.stash.internal.util.TransactionBatcher;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.PreDestroy;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.PlatformTransactionManager;

@Service(value="commitIndexingService")
public class DefaultCommitIndexingService
implements CommitIndexingService {
    private static final String MANUALLY_REGISTERED = "manual-indexers";
    private static final Logger log = LoggerFactory.getLogger(DefaultCommitIndexingService.class);
    private final CommitIndex commitIndex;
    private final I18nService i18nService;
    private final Multimap<String, CommitIndexer> indexers;
    private final IndexerStateDao indexerStateDao;
    private final RepositorySupplier repositorySupplier;
    private final ScmService scmService;
    private final RepositorySnapshotService snapshotService;
    private final PlatformTransactionManager transactionManager;
    private volatile boolean active;
    @Value(value="${indexing.job.batch.size}")
    private int indexBatchSize;
    @Value(value="${indexing.process.timeout.execution}")
    private long timeoutSeconds;

    @Autowired
    public DefaultCommitIndexingService(CommitIndex commitIndex, I18nService i18nService, IndexerStateDao indexerStateDao, RepositorySupplier repositorySupplier, ScmService scmService, RepositorySnapshotService snapshotService, PlatformTransactionManager transactionManager) {
        this.commitIndex = commitIndex;
        this.i18nService = i18nService;
        this.indexerStateDao = indexerStateDao;
        this.repositorySupplier = repositorySupplier;
        this.scmService = scmService;
        this.snapshotService = snapshotService;
        this.transactionManager = transactionManager;
        this.active = true;
        this.indexers = HashMultimap.create((int)2, (int)1);
    }

    @Override
    public void indexRepository(@Nonnull Repository repository) {
        log.debug("[{}] Request for indexing received", (Object)repository);
        if (!this.active) {
            log.info("[{}] Skipping indexing; indexing has been shut down", (Object)repository);
            return;
        }
        List<CommitIndexer> enabledIndexers = this.getEnabledIndexers(repository);
        if (enabledIndexers.isEmpty()) {
            log.debug("[{}] Skipping indexing; no enabled indexers found", (Object)repository);
            return;
        }
        new IndexOperation(repository, enabledIndexers).perform();
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @PreDestroy
    public void onDestroy() {
        this.active = false;
        log.debug("IndexingService is shutting down. Running indexing jobs will be aborted");
    }

    @PluginEventListener
    public synchronized void onPluginDisabled(PluginDisabledEvent event) {
        this.indexers.removeAll((Object)event.getPlugin().getKey());
    }

    @PluginEventListener
    public synchronized void onPluginEnabled(PluginEnabledEvent event) {
        Plugin plugin = event.getPlugin();
        String pluginKey = plugin.getKey();
        for (ModuleDescriptor module : plugin.getModuleDescriptorsByModuleClass(CommitIndexer.class)) {
            String moduleKey = module.getKey();
            CommitIndexer indexer = (CommitIndexer)module.getModule();
            if (indexer == null) {
                log.warn("Ignoring module {}:{}; the CommitIndexer was null", (Object)pluginKey, (Object)moduleKey);
                continue;
            }
            if (indexer.getId() == null) {
                log.warn("Ignoring module {}:{}; the CommitIndexer does not define an ID", (Object)pluginKey, (Object)moduleKey);
                continue;
            }
            log.debug("Registering module {}:{} as a CommitIndexer", (Object)pluginKey, (Object)moduleKey);
            this.indexers.put((Object)pluginKey, (Object)indexer);
        }
    }

    @VisibleForTesting
    synchronized Collection<CommitIndexer> getIndexers() {
        return Collections.unmodifiableCollection(this.indexers.values());
    }

    @VisibleForTesting
    synchronized void register(CommitIndexer indexer) {
        this.indexers.put((Object)MANUALLY_REGISTERED, (Object)indexer);
    }

    @VisibleForTesting
    void setIndexBatchSize(int indexBatchSize) {
        this.indexBatchSize = indexBatchSize;
    }

    private AsyncCommand<Void> commitsAdded(Repository repository, Long lastIndexingRun, long thisIndexingRun, CommitCallback callback) {
        Iterable<String> currentIndexingHeads = this.snapshotService.create(repository, thisIndexingRun);
        Iterable<String> lastIndexingHeads = this.getIndexedHeadsOrEmpty(repository, lastIndexingRun);
        return this.commitsBetween(repository, currentIndexingHeads, lastIndexingHeads, callback);
    }

    private AsyncCommand<Void> commitsBetween(Repository repository, Iterable<String> includedHeads, Iterable<String> excludedHeads, CommitCallback callback) {
        ScmCommandFactory commandFactory = this.scmService.getCommandFactory(repository);
        CommitsCommandParameters parameters = new CommitsCommandParameters.Builder().include(includedHeads).exclude(excludedHeads).build();
        return commandFactory.commits(parameters, callback).asynchronous();
    }

    private AsyncCommand<Void> commitsRemoved(Repository repository, Long lastIndexingRun, long thisIndexingRun, CommitCallback callback) {
        Iterable<String> lastIndexingHeads = this.getIndexedHeadsOrEmpty(repository, lastIndexingRun);
        Iterable<String> currentIndexingHeads = this.snapshotService.getByRepository(repository, thisIndexingRun);
        return this.commitsBetween(repository, lastIndexingHeads, currentIndexingHeads, callback);
    }

    private synchronized List<CommitIndexer> getEnabledIndexers(Repository repository) {
        if (this.indexers.isEmpty()) {
            return Collections.emptyList();
        }
        return Chainable.chain((Iterable)this.indexers.values()).filter(indexer -> indexer.isEnabledForRepository(repository)).toList();
    }

    private Iterable<String> getIndexedHeadsOrEmpty(Repository repository, Long timestamp) {
        try {
            return this.snapshotService.getByRepository(repository, timestamp);
        }
        catch (NoSuchResourceException e) {
            log.info("{} The snapshot for the previous indexing run could not be found. Indexing will start from the start of the commit history.", (Object)repository);
            return Collections.emptySet();
        }
    }

    private class IndexOperation
    implements UncheckedOperation<Void> {
        private final List<CommitIndexer> enabledIndexers;
        private final int repositoryId;
        private final String identifier;

        private IndexOperation(Repository repository, List<CommitIndexer> enabledIndexers) {
            this.enabledIndexers = Lists.newArrayList(enabledIndexers);
            this.identifier = "[" + repository.toString() + "]";
            this.repositoryId = repository.getId();
        }

        public Void perform() {
            this.index();
            return null;
        }

        private long calculateTimeout() {
            return System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(DefaultCommitIndexingService.this.timeoutSeconds);
        }

        private void eachIndexer(Iterable<CommitIndexer> indexers, Consumer<CommitIndexer> effect) {
            Iterator<CommitIndexer> it = indexers.iterator();
            while (it.hasNext()) {
                CommitIndexer indexer = it.next();
                try {
                    effect.accept(indexer);
                }
                catch (Exception e) {
                    it.remove();
                    log.warn("Commit indexer {} caused an error '{}' and has been disabled for the remainder of this indexing run. Enable debug logging to see the exception details.", (Object)indexer.getId(), (Object)StringUtils.defaultString((String)e.getMessage()));
                    log.debug("Commit indexer error:", (Throwable)e);
                }
            }
        }

        private String formatBatchId(int fromBatch) {
            return this.identifier + " indexCommitBatch(" + fromBatch + ".." + (fromBatch + DefaultCommitIndexingService.this.indexBatchSize) + ")";
        }

        private void handleTimeout(Future<Void> future, long timeoutTimestamp) {
            long now = System.currentTimeMillis();
            if (this.isTimeoutConfigured() && now > timeoutTimestamp) {
                log.info("{} Indexing SCM process has timed out, wrapping up the process", (Object)this.identifier);
                try {
                    future.get(10L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException e) {
                    log.debug(this.identifier + " An unexpected exception was thrown while processing an SCM timeout", (Throwable)e);
                }
                catch (TimeoutException e) {
                    KeyedMessage message = DefaultCommitIndexingService.this.i18nService.createKeyedMessage("bitbucket.service.commitindexing.timeout", new Object[]{this.identifier, DefaultCommitIndexingService.this.timeoutSeconds});
                    throw new CommitIndexingException(message);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void index() {
            if (log.isDebugEnabled()) {
                log.debug("{} Starting indexing with indexers [{}]", (Object)this.identifier, (Object)this.enabledIndexers.stream().map(CommitIndexer::getId).collect(Collectors.joining(", ")));
            }
            TransactionBatcher batch = new TransactionBatcher(DefaultCommitIndexingService.this.transactionManager, DefaultCommitIndexingService.this.indexBatchSize, this.identifier);
            try (Timer timer = TimerUtils.start((String)(this.identifier + " index repository"));){
                batch.start();
                InternalRepository repository = InternalConverter.convertToInternalRepository((Repository)DefaultCommitIndexingService.this.repositorySupplier.getById(this.repositoryId));
                if (repository == null) {
                    log.info("{} Skipping indexing; it appears the repository has been deleted", (Object)this.identifier);
                    return;
                }
                DefaultIndexingContext ctx = new DefaultIndexingContext((Repository)repository);
                ArrayList activeIndexers = Lists.newArrayList(this.enabledIndexers);
                this.notifyOnBefore(activeIndexers, ctx);
                if (activeIndexers.isEmpty()) {
                    log.debug("{} Skipping indexing; all enabled indexers have failed", (Object)this.identifier);
                    return;
                }
                Long lastIndexingRunTimestamp = DefaultCommitIndexingService.this.indexerStateDao.getOldestLastRunTimestamp(repository, (Iterable)activeIndexers);
                if (lastIndexingRunTimestamp == null && DefaultCommitIndexingService.this.scmService.isEmpty((Repository)repository)) {
                    log.debug("{} Skipping indexing for empty repository", (Object)this.identifier);
                    batch.commit();
                    return;
                }
                long thisIndexingRunTimestamp = System.currentTimeMillis();
                BlockingQueueCommitCallback commitQueue = new BlockingQueueCommitCallback(1024);
                AsyncCommand addCommand = DefaultCommitIndexingService.this.commitsAdded((Repository)repository, lastIndexingRunTimestamp, thisIndexingRunTimestamp, (CommitCallback)commitQueue);
                repository = this.indexCommits((AsyncCommand<Void>)addCommand, batch, repository, ctx, activeIndexers, commitQueue, true);
                if (!DefaultCommitIndexingService.this.active) {
                    return;
                }
                log.debug("{} Scanning for deleted commits...", (Object)this.identifier);
                commitQueue.clear();
                AsyncCommand delCommand = DefaultCommitIndexingService.this.commitsRemoved((Repository)repository, lastIndexingRunTimestamp, thisIndexingRunTimestamp, (CommitCallback)commitQueue);
                repository = this.indexCommits((AsyncCommand<Void>)delCommand, batch, repository, ctx, activeIndexers, commitQueue, false);
                if (!DefaultCommitIndexingService.this.active) {
                    return;
                }
                DefaultCommitIndexingService.this.indexerStateDao.setLastRunTimestamp(repository, (Iterable)activeIndexers, thisIndexingRunTimestamp);
                DefaultCommitIndexingService.this.snapshotService.pruneByRepository((Repository)repository, DefaultCommitIndexingService.this.indexerStateDao.getReferencedLastRunTimestamps(repository));
                batch.commit();
                this.notifyOnAfter(this.enabledIndexers, ctx);
                return;
            }
            catch (NoSuchResourceException | ConstraintViolationException | DataIntegrityViolationException e) {
                log.info("{} Repository was deleted during indexing. Indexing is aborted");
                return;
            }
            catch (IllegalStateException e) {
                log.info("{} Application shutdown during indexing. Indexing is aborted");
                return;
            }
            finally {
                if (batch.rollback()) {
                    log.info("{} Rolled back indexing transaction", (Object)this.identifier);
                }
                log.debug("{} Indexed {} commits", (Object)this.identifier, (Object)batch.getCount());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private InternalRepository indexCommits(AsyncCommand<Void> command, TransactionBatcher batch, InternalRepository repository, IndexingContext ctx, List<CommitIndexer> activeIndexers, BlockingQueueCommitCallback commitQueue, boolean add) {
            Future result = command.start();
            long timeoutTimestamp = this.calculateTimeout();
            try (Timer timer = TimerUtils.start((String)this.formatBatchId(batch.getCount()));){
                Commit commit;
                while (DefaultCommitIndexingService.this.active && (commit = commitQueue.poll(5L, TimeUnit.SECONDS)) != null) {
                    this.handleTimeout(result, timeoutTimestamp);
                    if (add) {
                        DefaultCommitIndexingService.this.commitIndex.addCommit(commit, (Repository)repository);
                    } else {
                        DefaultCommitIndexingService.this.commitIndex.removeCommit(commit.getId(), (Repository)repository);
                    }
                    Commit currentCommit = commit;
                    this.eachIndexer(activeIndexers, indexer -> {
                        if (add) {
                            indexer.onCommitAdded(currentCommit, ctx);
                        } else {
                            indexer.onCommitRemoved(currentCommit, ctx);
                        }
                    });
                    if (batch.tick()) {
                        timer.mark(this.formatBatchId(batch.getCount()));
                        log.debug("{} Completed batch, Indexed {} so far", (Object)this.identifier, (Object)batch.getCount());
                        repository = InternalConverter.convertToInternalRepository((Repository)DefaultCommitIndexingService.this.repositorySupplier.getById(repository.getId()));
                    }
                    if (!log.isTraceEnabled()) continue;
                    log.trace("{} Processed {} - {}", new Object[]{this.identifier, commit.getId(), batch.getCount()});
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.info("{} Indexing was interrupted", (Object)this.identifier);
            }
            finally {
                this.wrapUpCommand(result);
            }
            return repository;
        }

        private boolean isTimeoutConfigured() {
            return DefaultCommitIndexingService.this.timeoutSeconds > 0L;
        }

        private void notifyOnBefore(List<CommitIndexer> indexers, IndexingContext ctx) {
            try (Timer timer = TimerUtils.start((String)(this.identifier + " onBeforeIndexing"));){
                this.eachIndexer(indexers, indexer -> indexer.onBeforeIndexing(ctx));
            }
        }

        private void notifyOnAfter(List<CommitIndexer> indexers, IndexingContext ctx) {
            try (Timer timer = TimerUtils.start((String)(this.identifier + " onAfterIndexing"));){
                this.eachIndexer(indexers, indexer -> indexer.onAfterIndexing(ctx));
            }
        }

        private void wrapUpCommand(Future<Void> result) {
            log.trace("{} Waiting for SCM command to wrap up", (Object)this.identifier);
            try {
                result.get(10L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException e) {
                log.debug("{} SCM command did not finish on its own, canceling process", (Object)this.identifier);
                result.cancel(true);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.debug(this.identifier + " Interrupted while waiting for the process to complete", (Throwable)e);
                result.cancel(true);
            }
            catch (ExecutionException e) {
                log.debug(this.identifier + " Exception happened while waiting for the process to complete", (Throwable)e);
                result.cancel(true);
            }
        }
    }
}

