/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class SocketTransferInput
implements Closeable {
    private final DataInputStream in;

    public SocketTransferInput(InputStream in) {
        this.in = new DataInputStream(in);
    }

    @VisibleForTesting
    char readAsciiChar() throws IOException {
        byte b = (byte)this.in.read();
        if (b == -1) {
            throw new EOFException();
        }
        int c = b & 0xFF;
        Preconditions.checkState((c <= 127 ? 1 : 0) != 0, (Object)"Only ASCII characters are supported");
        return (char)c;
    }

    public Chunk readChunk() throws IOException {
        ChunkType type;
        return new Chunk(type, (type = ChunkType.forChar(this.readAsciiChar())) == ChunkType.END ? null : this.readString());
    }

    public String readRequestId() throws IOException {
        Chunk chunk = this.readChunk();
        Preconditions.checkState((chunk.getType() == ChunkType.REQUEST_ID ? 1 : 0) != 0);
        return chunk.getValue();
    }

    public String readHookType() throws IOException {
        Chunk chunk = this.readChunk();
        Preconditions.checkState((chunk.getType() == ChunkType.HOOK_TYPE ? 1 : 0) != 0);
        return chunk.getValue();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private String readString() throws IOException {
        int len = this.in.readUnsignedShort();
        byte[] buffer = new byte[len];
        this.in.readFully(buffer);
        return new String(buffer, StandardCharsets.UTF_8);
    }

    public static enum ChunkType {
        REQUEST_ID('X'),
        HOOK_TYPE('T'),
        ARG('A'),
        STDIN('I'),
        END('E');

        private final char character;

        private ChunkType(char character) {
            this.character = character;
        }

        public char getCharacter() {
            return this.character;
        }

        public static ChunkType forChar(char c) {
            for (ChunkType type : ChunkType.values()) {
                if (type.getCharacter() != c) continue;
                return type;
            }
            throw new IllegalArgumentException(String.format("Unknown channel %s", Character.valueOf(c)));
        }
    }

    public static class Chunk {
        private final ChunkType type;
        private final String value;

        public Chunk(ChunkType type, String value) {
            this.type = type;
            this.value = value;
        }

        public ChunkType getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }
    }
}

