/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.hook;

import com.atlassian.bitbucket.hook.HookHandler;
import com.atlassian.bitbucket.hook.HookRequest;
import com.atlassian.bitbucket.hook.HookRequestHandle;
import com.atlassian.bitbucket.hook.HookResponse;
import com.atlassian.bitbucket.hook.HookService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositorySupplier;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.FileUtils;
import com.atlassian.bitbucket.util.IoUtils;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.sal.api.executor.ThreadLocalContextManager;
import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.hook.DefaultHookRequest;
import com.atlassian.stash.internal.hook.DefaultHookResponse;
import com.atlassian.stash.internal.hook.SocketTransferInput;
import com.atlassian.stash.internal.hook.SocketTransferOutput;
import com.atlassian.stash.internal.scm.InternalScmService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.nio.BufferOverflowException;
import java.util.ArrayList;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Component;

@Component(value="hookService")
@AvailableToPlugins(value=HookService.class)
public class DefaultHookService
implements HookService {
    private static final String CALLBACK_SCRIPT = "hook-callback.pl";
    private static final String COORDINATOR_SCRIPT = "hook-coordinator.sh";
    private static final int DEFAULT_BACKLOG = 0;
    private static final Logger log = LoggerFactory.getLogger(DefaultHookService.class);
    private final ExecutorService executor;
    private final File hookScriptDirectory;
    private final RepositorySupplier repositorySupplier;
    private final ScmService scmService;
    private final SecureTokenGenerator tokenGenerator;
    private final ConcurrentMap<String, HookState> stateForScmRequest = Maps.newConcurrentMap();
    private final ThreadLocalContextManager<Object> stateManager;
    private final long hookBufferCapacity;
    private final String hookAddress;
    private final int hookPort;
    private ServerSocket serverSocket;
    private volatile boolean shutdown = false;

    @Autowired
    public DefaultHookService(ApplicationPropertiesService applicationPropertiesService, ExecutorService executor, RepositorySupplier repositorySupplier, InternalScmService scmService, ThreadLocalContextManager<Object> stateManager, SecureTokenGenerator tokenGenerator, @Value(value="${hook.callback.buffer.capacity}") long hookBufferCapacity, @Value(value="${hook.callback.socket.address}") String hookAddress, @Value(value="${hook.callback.socket.port}") int hookPort) throws IOException {
        this.executor = executor;
        this.repositorySupplier = repositorySupplier;
        this.scmService = scmService;
        this.stateManager = stateManager;
        this.tokenGenerator = tokenGenerator;
        this.hookBufferCapacity = Math.max(hookBufferCapacity, 32768L);
        this.hookAddress = Strings.emptyToNull((String)hookAddress);
        this.hookPort = Math.max(hookPort, 0);
        this.hookScriptDirectory = new File(applicationPropertiesService.getBinDir(), "git-hooks");
    }

    public <T> T doWithHookRequest(int repositoryId, @Nonnull Function<HookRequestHandle, T> callback) {
        Preconditions.checkNotNull(callback, (Object)"callback");
        try (HookRequestHandle handle = this.registerRequest(repositoryId);){
            T t = callback.apply(handle);
            return t;
        }
    }

    @Nonnull
    public HookRequestHandle registerRequest(int repositoryId) {
        String scmRequestId = this.tokenGenerator.generateToken();
        DefaultRequestHandle handle = new DefaultRequestHandle(scmRequestId);
        this.stateForScmRequest.put(scmRequestId, new HookState(handle, repositoryId, this.stateManager.getThreadLocalContext()));
        return handle;
    }

    @PostConstruct
    public void startup() throws IOException {
        this.installHookScripts();
        this.startHookCallbackListener();
    }

    @PreDestroy
    public void shutdown() {
        this.shutdown = true;
        try {
            if (this.serverSocket != null) {
                this.serverSocket.close();
            }
        }
        catch (IOException e) {
            log.warn("Could not close socket for hook callbacks", (Throwable)e);
        }
    }

    private void installHookScript(String scriptName, File targetDir) throws IOException {
        File scriptFile = new File(targetDir, scriptName);
        ClassPathResource script = new ClassPathResource("/hooks/" + scriptName, DefaultHookService.class);
        try (InputStream scriptStream = script.getInputStream();){
            IoUtils.copy((InputStream)scriptStream, (File)scriptFile);
        }
        if (!scriptFile.setExecutable(true)) {
            throw new IOException(scriptFile.getAbsolutePath() + " could not be set executable.");
        }
    }

    private void installHookScripts() throws IOException {
        if (this.hookScriptDirectory.exists() && !this.hookScriptDirectory.isDirectory()) {
            log.warn("{} must be a directory. Attempting to move the file", (Object)this.hookScriptDirectory.getAbsolutePath());
            try {
                File moved = new File(this.hookScriptDirectory.getParent(), this.hookScriptDirectory.getName() + ".moved");
                Files.move((File)this.hookScriptDirectory, (File)moved);
                log.warn("The file at {} has been renamed to {}", (Object)this.hookScriptDirectory.getAbsolutePath(), (Object)moved.getName());
            }
            catch (IOException e) {
                throw new IOException(this.hookScriptDirectory.getAbsolutePath() + " exists and is not a directory, " + "preventing installation of required hook support scripts.", e);
            }
        }
        try {
            FileUtils.mkdir((File)this.hookScriptDirectory);
        }
        catch (IllegalStateException e) {
            throw new IOException(this.hookScriptDirectory.getAbsolutePath() + " could not be created. Hook support scripts cannot be installed.", e);
        }
        try {
            this.installHookScript(CALLBACK_SCRIPT, this.hookScriptDirectory);
            this.installHookScript(COORDINATOR_SCRIPT, this.hookScriptDirectory);
        }
        catch (IOException e) {
            throw new IOException("Hook support scripts could not be written to " + this.hookScriptDirectory.getAbsolutePath(), e);
        }
    }

    private void startHookCallbackListener() throws IOException {
        this.serverSocket = new ServerSocket(this.hookPort, 0, InetAddress.getByName(this.hookAddress));
        Thread socketListenerThread = new Thread("hook-callback-listener"){

            @Override
            public void run() {
                while (!DefaultHookService.this.shutdown) {
                    Socket socket;
                    try {
                        socket = DefaultHookService.this.serverSocket.accept();
                    }
                    catch (Exception e) {
                        if (DefaultHookService.this.shutdown) continue;
                        log.warn("A hook connection could not be established; accept failed", (Throwable)e);
                        continue;
                    }
                    DefaultHookService.this.executor.submit(new Runnable(){

                        @Override
                        public void run() {
                            block38: {
                                try (Socket ignored = socket;
                                     SocketTransferInput input = new SocketTransferInput(socket.getInputStream());
                                     SocketTransferOutput output = new SocketTransferOutput(socket.getOutputStream());){
                                    DefaultHookService.this.handleRawRequest(input, output);
                                }
                                catch (Exception e) {
                                    if (DefaultHookService.this.shutdown) break block38;
                                    log.warn("Hook socket I/O failed before the repository/hook could be identified", (Throwable)e);
                                }
                            }
                        }
                    });
                }
            }
        };
        socketListenerThread.setDaemon(true);
        socketListenerThread.start();
        log.info("Hook callback socket listening on {}:{}", (Object)this.serverSocket.getInetAddress().getHostAddress(), (Object)this.serverSocket.getLocalPort());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    void handleRawRequest(SocketTransferInput input, SocketTransferOutput output) throws Exception {
        block15: {
            HookState hookState = null;
            DefaultHookRequest request = null;
            DefaultHookResponse response = new DefaultHookResponse();
            try (Timer timer = null;){
                hookState = this.getHookState(input);
                boolean acceptRequest = false;
                try {
                    request = this.createHookRequest(input);
                    timer = TimerUtils.start((String)("DefaultHookService hook callback " + request.getHookName() + " for repository " + hookState.getRepositoryId()));
                    acceptRequest = this.handleRequest(request, response, hookState);
                }
                catch (BufferOverflowException e) {
                    response.err().println("This push is too large to process.");
                }
                finally {
                    DefaultRequestHandle handle = hookState.getHandle();
                    handle.setAccepted(acceptRequest);
                    handle.setCalled(true);
                }
                this.writeResponse(output, response, acceptRequest);
            }
        }
    }

    @VisibleForTesting
    HookState getHookState(SocketTransferInput input) throws IOException {
        String scmRequestId = input.readRequestId();
        log.trace("Received hook callback with request id {}", (Object)scmRequestId);
        return (HookState)Preconditions.checkNotNull(this.stateForScmRequest.get(scmRequestId), (Object)"hookState");
    }

    @VisibleForTesting
    DefaultHookRequest createHookRequest(SocketTransferInput input) throws IOException {
        SocketTransferInput.Chunk chunk;
        String hookIdentifier = input.readHookType();
        log.trace("Received callback for hookType {}", (Object)hookIdentifier);
        ArrayList arguments = Lists.newArrayList();
        StringBuilder stdIn = new StringBuilder();
        long bufferSize = 0L;
        while ((chunk = input.readChunk()).getType() != SocketTransferInput.ChunkType.END) {
            if (this.hookBufferCapacity > 0L && bufferSize > this.hookBufferCapacity) {
                throw new BufferOverflowException();
            }
            switch (chunk.getType()) {
                case ARG: {
                    arguments.add(chunk.getValue());
                    break;
                }
                case STDIN: {
                    stdIn.append(chunk.getValue());
                    break;
                }
                default: {
                    throw new IllegalStateException("Invalid input from hook request");
                }
            }
            bufferSize += (long)chunk.getValue().length() * 2L;
        }
        return new DefaultHookRequest(hookIdentifier, arguments, stdIn);
    }

    @VisibleForTesting
    void writeResponse(SocketTransferOutput output, DefaultHookResponse response, boolean acceptRequest) throws IOException {
        String err;
        String out = response.getOutput();
        if (out.length() > 0) {
            output.writeStdOut(out);
        }
        if ((err = response.getError()).length() > 0) {
            output.writeStdErr(err);
        }
        output.writeExitCode((short)(!acceptRequest ? 1 : 0));
        output.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @VisibleForTesting
    boolean handleRequest(HookRequest request, HookResponse response, HookState hookState) throws IOException {
        this.stateManager.setThreadLocalContext(hookState.getThreadLocalState());
        try {
            boolean bl = this.doHandleRequest(request, response, hookState);
            return bl;
        }
        finally {
            this.stateManager.clearThreadLocalContext();
        }
    }

    @VisibleForTesting
    boolean doHandleRequest(HookRequest request, HookResponse response, HookState hookState) throws IOException {
        Repository repository = this.repositorySupplier.getById(hookState.getRepositoryId());
        if (repository == null) {
            log.warn("Failed to find repository with id {} for hook callback", (Object)hookState.getRepositoryId());
            return false;
        }
        HookHandler handler = this.scmService.getHookHandlerFactory(repository).create(request);
        return handler == null || handler.handle(request, response);
    }

    private class DefaultRequestHandle
    implements HookRequestHandle {
        private final String requestId;
        private volatile boolean accepted;
        private volatile boolean called;

        private DefaultRequestHandle(String requestId) {
            this.requestId = requestId;
        }

        public void close() {
            DefaultHookService.this.stateForScmRequest.remove(this.requestId);
        }

        @Nonnull
        public File getCallbackScript() {
            return new File(DefaultHookService.this.hookScriptDirectory, DefaultHookService.CALLBACK_SCRIPT);
        }

        @Nonnull
        public File getCoordinatorScript() {
            return new File(DefaultHookService.this.hookScriptDirectory, DefaultHookService.COORDINATOR_SCRIPT);
        }

        @Nonnull
        public String getHostAddress() {
            return DefaultHookService.this.serverSocket.getInetAddress().getHostAddress();
        }

        public int getPort() {
            return DefaultHookService.this.serverSocket.getLocalPort();
        }

        @Nonnull
        public String getRequestId() {
            return this.requestId;
        }

        public boolean isAccepted() {
            return this.accepted;
        }

        public boolean isCalled() {
            return this.called;
        }

        public void setAccepted(boolean accepted) {
            this.accepted = accepted;
        }

        public void setCalled(boolean called) {
            this.called = called;
        }
    }

    @VisibleForTesting
    static class HookState {
        private final DefaultRequestHandle handle;
        private final int repositoryId;
        private final Object threadLocalState;

        private HookState(DefaultRequestHandle handle, int repositoryId, Object threadLocalState) {
            this.handle = handle;
            this.repositoryId = repositoryId;
            this.threadLocalState = threadLocalState;
        }

        public DefaultRequestHandle getHandle() {
            return this.handle;
        }

        public int getRepositoryId() {
            return this.repositoryId;
        }

        public Object getThreadLocalState() {
            return this.threadLocalState;
        }
    }
}

