/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.help;

import com.atlassian.bitbucket.help.HelpPathService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.help.AbstractHelpPathService;
import com.atlassian.stash.internal.i18n.LocaleHolder;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.Locale;
import org.apache.http.client.utils.URIBuilder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@AvailableToPlugins(value=HelpPathService.class)
@Component(value="helpPathService")
public class I18nHelpPathService
extends AbstractHelpPathService {
    private final I18nService i18nService;
    private final LocaleHolder localeHolder;

    @Autowired
    public I18nHelpPathService(I18nService i18nService, LocaleHolder localeHolder) {
        this.localeHolder = localeHolder;
        this.i18nService = i18nService;
    }

    protected String getProperty(String key) {
        return this.i18nService.getMessage(key, new Object[0]);
    }

    public String getPageUrl(String topicKey) {
        String rawURL = super.getPageUrl(topicKey);
        if (rawURL == null) {
            return null;
        }
        try {
            URIBuilder builder = new URIBuilder(rawURL);
            String localeParam = this.getLocaleParam();
            if (localeParam != null) {
                builder.addParameter("locale", localeParam);
            }
            return builder.build().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private String getLocaleParam() {
        Locale l;
        StringBuilder b = new StringBuilder();
        String en = Locale.ENGLISH.getLanguage();
        Iterator iterator = this.localeHolder.getLocales(new Locale[0]).iterator();
        while (iterator.hasNext() && !en.equals((l = (Locale)iterator.next()).getLanguage())) {
            b.append(l);
            b.append(",");
        }
        return b.length() == 0 ? null : b.substring(0, b.length() - 1);
    }
}

