/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.commit.graph.cache;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.ScmService;
import com.atlassian.stash.internal.commit.graph.cache.TimedContentProvider;
import com.atlassian.stash.internal.commit.graph.cache.TraversalScmContentProvider;
import com.atlassian.util.contentcache.ContentProvider;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class CachedCommitGraphUtils {
    private static final int COMMIT_ID_LENGTH = 40;

    public static byte[] getCommitIdAsByteArray(String commitId) {
        if (commitId.length() != 40) {
            throw new IllegalArgumentException("Invalid commit ID: " + commitId);
        }
        try {
            return Hex.decodeHex((char[])commitId.toCharArray());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static String getByteArrayAsCommitId(byte[] commitId) {
        if (commitId.length != 20) {
            throw new IllegalArgumentException("Invalid commit ID (length is " + commitId.length + ')');
        }
        return new String(Hex.encodeHex((byte[])commitId));
    }

    public static byte[] getCountAsByteArray(int count) {
        if (count < 0) {
            throw new IllegalArgumentException("Count cannot be negative");
        }
        if (count == 0) {
            return new byte[1];
        }
        int length = CachedCommitGraphUtils.arrayCountSize(count);
        byte[] buffer = new byte[length];
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)(count & 0x7F);
            if ((count >>>= 7) <= 0) continue;
            int n = i;
            buffer[n] = (byte)(buffer[n] | 0x80);
        }
        return buffer;
    }

    public static int getByteArrayAsCount(byte[] count) {
        return CachedCommitGraphUtils.getByteArrayAsCount(count, 0, count.length);
    }

    public static int getByteArrayAsCount(byte[] count, int offset, int length) {
        if (length == 0) {
            throw new IllegalArgumentException("Count must be a non-zero length array");
        }
        int r = 0;
        for (int i = offset; i < length; ++i) {
            r += (count[i] & 0x7F) << i * 7;
        }
        return r;
    }

    public static ContentProvider getTimedScmContentProvider(Repository repository, ScmService scmService, I18nService i18nService) {
        return new TimedContentProvider(repository.toString() + ": TraversalScmContentProvider", new TraversalScmContentProvider(scmService, repository, i18nService));
    }

    public static boolean isLastByteInCountArray(int b) {
        return (b & 0x80) != 128;
    }

    private static int arrayCountSize(int count) {
        int highestBit = 32 - Integer.numberOfLeadingZeros(count);
        int required = highestBit / 7;
        return highestBit % 7 == 0 ? required : required + 1;
    }
}

