/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.comment;

import com.atlassian.bitbucket.comment.CommentChain;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.task.Task;
import com.atlassian.bitbucket.task.TaskAnchor;
import com.atlassian.bitbucket.task.TaskAnchorType;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.stash.internal.InternalConverter;
import com.atlassian.stash.internal.comment.InternalComment;
import com.atlassian.stash.internal.comment.InternalCommentable;
import com.atlassian.stash.internal.pull.InternalPullRequest;
import com.atlassian.stash.internal.pull.comment.CommentPostProcessor;
import com.atlassian.stash.internal.task.InternalTaskContext;
import com.atlassian.stash.internal.task.InternalTaskSearchRequest;
import com.atlassian.stash.internal.task.InternalTaskService;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TaskCommentPostProcessor
implements CommentPostProcessor {
    private static final Function<TaskAnchor, Long> TO_ANCHOR_ID = new Function<TaskAnchor, Long>(){

        public Long apply(TaskAnchor anchor) {
            return anchor.getId();
        }
    };
    private final int maxTasksPerSearch;
    private final InternalTaskService taskService;

    public TaskCommentPostProcessor(InternalTaskService taskService, int maxTasksPerSearch) {
        this.maxTasksPerSearch = maxTasksPerSearch;
        this.taskService = taskService;
    }

    @Override
    public InternalComment process(InternalCommentable entity, InternalComment comment) {
        this.processAll(entity, Collections.singleton(comment));
        return comment;
    }

    @Override
    public Set<InternalComment> processAll(InternalCommentable entity, Set<InternalComment> rootComments) {
        if (!(entity instanceof InternalTaskContext) || rootComments.isEmpty()) {
            return rootComments;
        }
        InternalPullRequest context = InternalConverter.convertToInternalPullRequest((PullRequest)((PullRequest)entity));
        CommentChain allComments = new CommentChain(rootComments);
        Map<Long, List<Task>> tasksByComment = this.retrieveTasks((InternalTaskContext)context, (Iterable<? extends TaskAnchor>)allComments);
        for (InternalComment comment : allComments) {
            if (comment.hasTasks()) continue;
            List<Task> tasksForComment = tasksByComment.get(comment.getId());
            comment.setTasks(tasksForComment == null ? Collections.emptyList() : Collections.unmodifiableList(tasksForComment));
        }
        return rootComments;
    }

    private Map<Long, List<Task>> retrieveTasks(InternalTaskContext pullRequest, Iterable<? extends TaskAnchor> anchors) {
        ImmutableSet allCommentIds = ImmutableSet.copyOf((Iterable)Iterables.transform(anchors, TO_ANCHOR_ID));
        InternalTaskSearchRequest taskSearchRequest = new InternalTaskSearchRequest.Builder(pullRequest).anchors((Iterable)allCommentIds, TaskAnchorType.COMMENT).build();
        Page page = this.taskService.search(taskSearchRequest, PageUtils.newRequest((int)0, (int)this.maxTasksPerSearch), false);
        HashMap<Long, List<Task>> tasks = new HashMap<Long, List<Task>>();
        for (Task task : page.getValues()) {
            TaskAnchor anchor = task.getAnchor();
            ArrayList<Task> tasksForAnchor = (ArrayList<Task>)tasks.get(anchor.getId());
            if (tasksForAnchor == null) {
                tasksForAnchor = new ArrayList<Task>(3);
                tasks.put(anchor.getId(), tasksForAnchor);
            }
            tasksForAnchor.add(task);
        }
        return tasks;
    }
}

