/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.cluster;

import com.atlassian.security.random.SecureTokenGenerator;
import com.atlassian.stash.internal.ApplicationSettings;
import com.atlassian.stash.internal.cluster.ClusterJoinCheck;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckAction;
import com.atlassian.stash.internal.cluster.ClusterJoinCheckResult;
import com.atlassian.stash.internal.cluster.ClusterJoinRequest;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.jdbc.DataSourceConfiguration;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.Charsets;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SharedHomeAndDatabaseJoinCheck
implements ClusterJoinCheck {
    private final ApplicationSettings applicationSettings;
    private final ConfigurationService configurationService;
    private final DataSourceConfiguration dataSourceConfiguration;
    private final SecureTokenGenerator secureTokenGenerator;

    @Autowired
    public SharedHomeAndDatabaseJoinCheck(ApplicationSettings applicationSettings, ConfigurationService configurationService, DataSourceConfiguration dataSourceConfiguration, SecureTokenGenerator secureTokenGenerator) {
        this.applicationSettings = applicationSettings;
        this.configurationService = configurationService;
        this.dataSourceConfiguration = dataSourceConfiguration;
        this.secureTokenGenerator = secureTokenGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nonnull
    public ClusterJoinCheckResult accept(@Nonnull ClusterJoinRequest request) throws IOException {
        boolean databaseMatches;
        File tmpFile = null;
        boolean sharedHomeMatches = false;
        try {
            tmpFile = File.createTempFile("cluster-join", ".txt", this.applicationSettings.getSharedHomeDir());
            String token = this.secureTokenGenerator.generateToken();
            Files.write((CharSequence)token, (File)tmpFile, (Charset)Charsets.UTF_8);
            request.out().writeUTF(tmpFile.getName());
            if (request.in().readBoolean()) {
                sharedHomeMatches = token.equals(request.in().readUTF());
            }
        }
        finally {
            if (tmpFile != null && !tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
        String remoteJdbcUrl = request.in().readUTF();
        String remoteJdbcUser = request.in().readUTF();
        boolean bl = databaseMatches = this.dataSourceConfiguration.getUrl().equals(remoteJdbcUrl) && this.dataSourceConfiguration.getUser().equals(remoteJdbcUser);
        if (sharedHomeMatches) {
            if (databaseMatches) {
                return ClusterJoinCheckResult.OK;
            }
            DataSourceConfiguration onDiskConfiguration = this.configurationService.loadDataSourceConfiguration();
            boolean onDiskConfigMatchesCurrent = Objects.equals(onDiskConfiguration.getUrl(), this.dataSourceConfiguration.getUrl()) && Objects.equals(onDiskConfiguration.getUser(), this.dataSourceConfiguration.getUser());
            return ClusterJoinCheckResult.passivate(onDiskConfigMatchesCurrent ? ClusterJoinCheckAction.PASSIVATE_OTHER_NODE : ClusterJoinCheckAction.PASSIVATE_THIS_NODE, "Nodes are connected to the same shared home but different databases");
        }
        return databaseMatches ? ClusterJoinCheckResult.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Nodes are connected to the same database but different shared homes") : ClusterJoinCheckResult.disconnect("Node is part of an unrelated cluster");
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult connect(@Nonnull ClusterJoinRequest request) throws IOException {
        File tmpFile = new File(this.applicationSettings.getSharedHomeDir(), request.in().readUTF());
        boolean fileExists = tmpFile.isFile();
        request.out().writeBoolean(fileExists);
        if (fileExists) {
            String token = Files.toString((File)tmpFile, (Charset)StandardCharsets.UTF_8);
            request.out().writeUTF(token);
        }
        request.out().writeUTF(this.dataSourceConfiguration.getUrl());
        request.out().writeUTF(this.dataSourceConfiguration.getUser());
        return ClusterJoinCheckResult.OK;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.getClass().getName();
    }

    public int getOrder() {
        return 1;
    }

    @Override
    @Nonnull
    public ClusterJoinCheckResult onUnknown(@Nonnull ClusterJoinRequest request) {
        return ClusterJoinCheckResult.passivate(ClusterJoinCheckAction.PASSIVATE_ANY_NODE, "Cannot verify whether the nodes connect to the same database and shared home");
    }
}

