/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.bootstrap;

import com.atlassian.bitbucket.server.ApplicationMode;
import com.atlassian.bitbucket.util.UrlUtils;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.stash.internal.bootstrap.BootstrapOperation;
import com.atlassian.stash.internal.config.ConfigurationService;
import com.atlassian.stash.internal.config.RemoveSetupConfigurationRequest;
import com.atlassian.stash.internal.license.DualLicense;
import com.atlassian.stash.internal.license.InternalLicenseService;
import com.atlassian.stash.internal.license.LicenseHelper;
import com.atlassian.stash.internal.profiles.Dev;
import com.atlassian.stash.internal.server.ApplicationPropertyDao;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.user.GlobalPermissionDao;
import com.atlassian.stash.internal.user.StashUserDao;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Dev
@Component(value="bootstrapOperation")
public class DevBootstrapOperation
extends BootstrapOperation {
    public static final String LICENSE_CLUSTERED = "AAABAA0ODAoPeNptUE1Lw0AUvPdXLHhOybZGsbCgpiE2aJrSDZ6f8dUuJJvy3ibYf2+M22LF63wxM\n1ev+C6yzgopRXi3iORiFopkq8UslNcTdsD7adJD3YEzrVU7qBk9HBOO4BIcqm95EN4EUp7Y1jqoX\nA4NqgdXA7MBKzSyQ/KSFzDWoQVbYfJ5MHQck4r5k+cHu+lROerwMjQZnLVyY9Y9nMKnVdt43bOp0\nDLq4wHHAnpYtMrTyRapR1ot1WNWboLNPNZBWmZRoKPb1FsLIGeRRpuH1vQB1vDPA+ctnhw6Q4zDD\nvpdNO+aN6T1rmQkVnJ22evftUVH1R4Y/975BcASkF4wLQIVAJHuXZz1SsymUm2B5V7p7Pap48xzA\nhROyzM1l9a1OqcWzxseRNmnZ4XqmQ==X02d9";
    private static final Logger log = LoggerFactory.getLogger(DevBootstrapOperation.class);
    private static final List<UserData> ADMINISTRATORS = ImmutableList.of((Object)new UserData("admin", "Administrator", "admin@example.com"));
    private static final List<UserData> USERS = ImmutableList.of((Object)new UserData("user", "User", "user@example.com"));

    @Autowired
    public DevBootstrapOperation(DirectoryManager directoryManager, InternalApplicationPropertiesService propertiesService, StashUserDao userDao, Properties applicationProperties, ApplicationManager appManager, LicenseHelper licenseHelper, ConfigurationService configurationService, GlobalPermissionDao globalPermissionDao, ApplicationPropertyDao applicationPropertyDao, InternalLicenseService licenseService) {
        super(directoryManager, propertiesService, userDao, applicationProperties, appManager, licenseHelper, configurationService, globalPermissionDao, applicationPropertyDao, licenseService);
    }

    @Override
    protected boolean setupLicense(RemoveSetupConfigurationRequest.Builder builder) {
        if (super.setupLicense(builder)) {
            return true;
        }
        this.licenseService.set(LICENSE_CLUSTERED);
        return true;
    }

    @Override
    protected boolean setupBaseUrl(RemoveSetupConfigurationRequest.Builder builder) {
        if (super.setupBaseUrl(builder)) {
            return true;
        }
        this.propertiesService.setBaseURL(UrlUtils.uncheckedCreateURI((String)String.format("http://%s:7990/bitbucket", this.getBaseUrlMachineName())));
        return true;
    }

    @Override
    protected boolean setupUsers(RemoveSetupConfigurationRequest.Builder builder, Directory directory) {
        try {
            boolean isMirror = this.applicationMode == ApplicationMode.MIRROR;
            DualLicense license = this.licenseHelper.getDecoded();
            if (license == null) {
                throw new IllegalStateException("A license must be set prior to adding dev mode users");
            }
            int licensedUsers = 0;
            for (UserData admin : ADMINISTRATORS) {
                this.createUser(directory, admin.username, admin.username, admin.displayName, admin.emailAddress, true, true);
                ++licensedUsers;
            }
            if (!isMirror) {
                for (UserData data : USERS) {
                    boolean willExceedLicense = licensedUsers >= license.getMaximumNumberOfUsers();
                    this.createUser(directory, data.username, data.username, data.displayName, data.emailAddress, !willExceedLicense, false);
                    if (willExceedLicense) {
                        log.warn("Not adding {} to {}; there are already {} licensed users", new Object[]{data.username, "stash-users", licensedUsers});
                        continue;
                    }
                    ++licensedUsers;
                }
            }
            return true;
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    protected String getBaseUrlMachineName() {
        try {
            if (this.initBaseUrlWithMachineHost()) {
                return InetAddress.getLocalHost().getHostName().toLowerCase(Locale.US);
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "localhost";
    }

    private boolean initBaseUrlWithMachineHost() {
        return Boolean.getBoolean("stash.dev.init.baseurl.with.machine.host");
    }

    private static class UserData {
        private final String displayName;
        private final String username;
        private final String emailAddress;

        private UserData(String username, String displayName, String emailAddress) {
            this.username = username;
            this.displayName = displayName;
            this.emailAddress = emailAddress;
        }
    }
}

