/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.backup;

import com.atlassian.stash.internal.backup.Backup;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nonnull;

public class FileBackup
implements Backup {
    public static final Function<File, Backup> FILE_TRANSFORM = new Function<File, Backup>(){

        public FileBackup apply(File file) {
            return new FileBackup(file);
        }
    };
    private final File file;

    public FileBackup(@Nonnull File file) {
        this.file = (File)Preconditions.checkNotNull((Object)file, (Object)"file");
    }

    public long getModified() {
        return this.file.lastModified();
    }

    @Nonnull
    public String getName() {
        return this.file.getName();
    }

    public long getSize() {
        return this.file.length();
    }

    @Nonnull
    public InputStream getInput() throws IOException {
        return new FileInputStream(this.file);
    }
}

