/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.avatar;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.avatar.AvatarStoreException;
import com.atlassian.bitbucket.avatar.AvatarSupplier;
import com.atlassian.bitbucket.avatar.CacheableAvatarSupplier;
import com.atlassian.bitbucket.avatar.SimpleAvatarSupplier;
import com.atlassian.bitbucket.event.project.ProjectDeletedEvent;
import com.atlassian.bitbucket.event.user.UserCleanupEvent;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.project.PersonalProject;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectVisitor;
import com.atlassian.bitbucket.request.RequestContext;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.RequestLocalCache;
import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettings;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.cache.Supplier;
import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.AvailableToPlugins;
import com.atlassian.stash.internal.AbstractService;
import com.atlassian.stash.internal.annotation.NotProfiled;
import com.atlassian.stash.internal.annotation.Unsecured;
import com.atlassian.stash.internal.avatar.AvatarRepository;
import com.atlassian.stash.internal.avatar.AvatarSource;
import com.atlassian.stash.internal.avatar.AvatarType;
import com.atlassian.stash.internal.avatar.AvatarUrlDecorator;
import com.atlassian.stash.internal.avatar.InternalAvatarService;
import com.atlassian.stash.internal.server.InternalApplicationPropertiesService;
import com.atlassian.stash.internal.spring.SpringTransactionUtils;
import com.google.common.base.Preconditions;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import org.apache.commons.codec.binary.Base64InputStream;
import org.apache.commons.codec.binary.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@AvailableToPlugins(value=AvatarService.class)
@NotProfiled
@Service(value="avatarService")
@Transactional(propagation=Propagation.SUPPORTS)
public class ConfigurableAvatarService
extends AbstractService
implements InternalAvatarService {
    public static final String DEFAULT_SOURCE = "default";
    public static final String DISABLED_SOURCE = "disabled";
    private static final String CACHE_NAME = InternalAvatarService.class.getName();
    private static final Pattern PATTERN_DATA_URI = Pattern.compile("data:([^;]+);base64,([A-Za-z0-9+/]+)=*$");
    private static final Logger log = LoggerFactory.getLogger(ConfigurableAvatarService.class);
    private final CachedReference<AvatarSource> activeSource;
    private final RequestLocalCache<AvatarKey, String> avatarCache;
    private final AvatarUrlDecorator urlDecorator;
    private final AvatarSource defaultSource;
    private final AvatarSource disabledSource;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final InternalApplicationPropertiesService propertiesService;
    private final AvatarRepository repository;

    @Autowired
    public ConfigurableAvatarService(I18nService i18nService, NavBuilder navBuilder, InternalApplicationPropertiesService propertiesService, AvatarRepository repository, CacheFactory cacheFactory, AvatarUrlDecorator urlDecorator, @Qualifier(value="urlAvatarSource") AvatarSource defaultSource, @Qualifier(value="webResourceAvatarSource") AvatarSource disabledSource, RequestContext requestContext) {
        this.defaultSource = defaultSource;
        this.disabledSource = disabledSource;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.propertiesService = propertiesService;
        this.repository = repository;
        this.urlDecorator = urlDecorator;
        this.activeSource = this.createCachedReference(cacheFactory);
        this.avatarCache = new RequestLocalCache(requestContext);
    }

    @Nonnull
    @Unsecured(value="Creating a supplier from a data URI requires no specific permission")
    public AvatarSupplier createSupplierFromDataUri(@Nonnull String uri) {
        Preconditions.checkNotNull((Object)uri, (Object)"uri");
        uri = uri.replaceAll("\\s", "").replace('-', '+').replace('_', '/');
        Matcher matcher = PATTERN_DATA_URI.matcher(uri);
        if (!matcher.matches()) {
            throw new AvatarStoreException(this.i18nService.createKeyedMessage("bitbucket.service.avatar.invaliddatauri", new Object[0]));
        }
        String contentType = matcher.group(1);
        String data = matcher.group(2);
        ByteArrayInputStream base64Data = new ByteArrayInputStream(StringUtils.getBytesUtf8((String)data));
        return new SimpleAvatarSupplier(contentType, (InputStream)new Base64InputStream((InputStream)base64Data));
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void deleteForUser(@Nonnull ApplicationUser user) {
        this.repository.delete(AvatarType.USER, (Object)user.getId());
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getForProject(@Nonnull Project project, int size) {
        Preconditions.checkNotNull((Object)project, (Object)"project");
        return this.repository.load(AvatarType.PROJECT, (Object)project.getId(), size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getForUser(@Nonnull ApplicationUser user, int size) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        return this.repository.load(AvatarType.USER, (Object)user.getId(), size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getProjectDefault(int size) {
        return this.repository.loadDefault(AvatarType.PROJECT, size);
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForPerson(final @Nonnull Person person, final @Nonnull AvatarRequest request) {
        Preconditions.checkNotNull((Object)person, (Object)"person");
        Preconditions.checkNotNull((Object)request, (Object)"request");
        return (String)this.avatarCache.get((Object)AvatarKey.forPerson(person, request), (Supplier)new Supplier<String>(){

            public String get() {
                return ConfigurableAvatarService.this.doGetUrlForPerson(person, request);
            }
        });
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public String getUrlForProject(final @Nonnull Project project, final @Nonnull AvatarRequest request) {
        Preconditions.checkNotNull((Object)project, (Object)"project");
        return (String)this.avatarCache.get(project.accept((ProjectVisitor)new AvatarKeyVisitor(request)), (Supplier)new Supplier<String>(){

            public String get() {
                return (String)project.accept((ProjectVisitor)new AvatarProjectVisitor(request));
            }
        });
    }

    @Nonnull
    @Unsecured(value="Avatars are trivial data which is available in any context, including non-authenticated contexts")
    public CacheableAvatarSupplier getUserDefault(int size) {
        return this.repository.loadDefault(AvatarType.USER, size);
    }

    @Unsecured(value="Anyone is allowed to check whether avatars are enabled")
    public boolean isEnabled() {
        return this.activeSource.get() == this.defaultSource;
    }

    @Unsecured(value="Anyone is allowed to check whether a user's avatar is locally stored")
    public boolean isLocalForUser(@Nonnull ApplicationUser user) {
        return this.repository.isStored(AvatarType.USER, (Object)((ApplicationUser)Preconditions.checkNotNull((Object)user, (Object)"user")).getId());
    }

    @EventListener
    public void onProjectDeleted(ProjectDeletedEvent event) {
        this.cleanup(AvatarType.PROJECT, event.getProject().getId());
        this.urlDecorator.invalidate(event.getProject());
    }

    @EventListener
    public void onUserCleanup(UserCleanupEvent event) {
        this.cleanup(AvatarType.USER, event.getDeletedUser().getId());
        this.urlDecorator.invalidate(event.getDeletedUser());
    }

    @PreAuthorize(value="hasProjectPermission(#project, 'PROJECT_ADMIN')")
    public void saveForProject(@Nonnull Project project, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkNotNull((Object)project, (Object)"project");
        this.repository.store(AvatarType.PROJECT, (Object)project.getId(), supplier);
        this.urlDecorator.invalidate(project);
    }

    @PreAuthorize(value="isCurrentUser(#user) or hasGlobalPermission('SYS_ADMIN') or (hasGlobalPermission('ADMIN') and not hasGlobalPermission(#user, 'SYS_ADMIN'))")
    public void saveForUser(@Nonnull ApplicationUser user, @Nonnull AvatarSupplier supplier) {
        Preconditions.checkNotNull((Object)user, (Object)"user");
        this.repository.store(AvatarType.USER, (Object)user.getId(), supplier);
        this.urlDecorator.invalidate(user);
    }

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    @PreAuthorize(value="hasGlobalPermission('ADMIN')")
    public void setEnabled(boolean enabled) {
        this.propertiesService.setAvatarSource(enabled ? DEFAULT_SOURCE : DISABLED_SOURCE);
        SpringTransactionUtils.invokeAfterCommit((Runnable)new Runnable(){

            @Override
            public void run() {
                ConfigurableAvatarService.this.activeSource.reset();
            }
        });
    }

    private void cleanup(AvatarType type, Object id) {
        try {
            this.repository.delete(type, id);
        }
        catch (AvatarStoreException e) {
            if (log.isDebugEnabled()) {
                log.debug("Could not cleanup avatars for " + type + " " + id, (Throwable)e);
            }
            log.warn("Could not cleanup avatars for " + type + " " + id + ": " + e.getMessage());
        }
    }

    private CachedReference<AvatarSource> createCachedReference(CacheFactory cacheFactory) {
        Supplier<AvatarSource> cacheLoader = new Supplier<AvatarSource>(){

            public AvatarSource get() {
                if (ConfigurableAvatarService.DISABLED_SOURCE.equals(ConfigurableAvatarService.this.propertiesService.getAvatarSource())) {
                    return ConfigurableAvatarService.this.disabledSource;
                }
                return ConfigurableAvatarService.this.defaultSource;
            }
        };
        CacheSettings cacheSettings = new CacheSettingsBuilder().replicateViaInvalidation().build();
        return cacheFactory.getCachedReference(CACHE_NAME, (Supplier)cacheLoader, cacheSettings);
    }

    @Nonnull
    private String doGetUrlForPerson(Person person, AvatarRequest request) {
        ApplicationUser user;
        if (person instanceof ApplicationUser && this.repository.isStored(AvatarType.USER, (Object)(user = (ApplicationUser)person).getId())) {
            NavBuilder.Builder builder = this.navBuilder.user(user).avatar(request.getSize());
            this.urlDecorator.decorate(builder, user);
            return request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }
        return ((AvatarSource)this.activeSource.get()).getUrlForPerson(person, request);
    }

    private class AvatarProjectVisitor
    implements ProjectVisitor<String> {
        private final AvatarRequest request;

        private AvatarProjectVisitor(AvatarRequest request) {
            this.request = (AvatarRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        public String visit(@Nonnull Project project) {
            NavBuilder.Builder builder = ConfigurableAvatarService.this.navBuilder.project(project).avatar(this.request.getSize());
            ConfigurableAvatarService.this.urlDecorator.decorate(builder, project);
            return this.request.isUseConfigured() ? builder.buildConfigured() : builder.buildRelative();
        }

        public String visit(@Nonnull PersonalProject project) {
            return ConfigurableAvatarService.this.getUrlForPerson((Person)project.getOwner(), this.request);
        }
    }

    private static class AvatarKeyVisitor
    implements ProjectVisitor<AvatarKey> {
        private final AvatarRequest request;

        private AvatarKeyVisitor(AvatarRequest request) {
            this.request = (AvatarRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        public AvatarKey visit(@Nonnull Project project) {
            return AvatarKey.forProject(project, this.request);
        }

        public AvatarKey visit(@Nonnull PersonalProject project) {
            return AvatarKey.forPerson((Person)project.getOwner(), this.request);
        }
    }

    private static class AvatarKey {
        private final Object owner;
        private final AvatarRequest request;

        private AvatarKey(Object owner, AvatarRequest request) {
            this.owner = Preconditions.checkNotNull((Object)owner, (Object)"owner");
            this.request = (AvatarRequest)Preconditions.checkNotNull((Object)request, (Object)"request");
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            AvatarKey that = (AvatarKey)other;
            return this.owner.equals(that.owner) && this.request.equals((Object)that.request);
        }

        public int hashCode() {
            return Objects.hash(this.owner, this.request);
        }

        static AvatarKey forPerson(Person person, AvatarRequest request) {
            return new AvatarKey(AvatarKey.personId(person), request);
        }

        static AvatarKey forProject(Project project, AvatarRequest request) {
            return new AvatarKey(project.getKey(), request);
        }

        @Nonnull
        private static Object personId(Person person) {
            if (person instanceof ApplicationUser) {
                return ((ApplicationUser)person).getId();
            }
            return org.apache.commons.lang3.StringUtils.defaultString((String)person.getEmailAddress());
        }
    }
}

