/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.pull.rescope;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.pull.PullRequestRescope;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.stash.internal.pull.rescope.DeclineOutcome;
import com.atlassian.stash.internal.pull.rescope.RescopeOutcome;
import com.atlassian.stash.internal.pull.rescope.SimpleMinimalPullRequest;
import java.util.Date;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimplePullRequestRescope
implements PullRequestRescope {
    private final Date date;
    private final String newFromHash;
    private final String newToHash;
    private final String oldFromHash;
    private final String oldToHash;
    private final SimpleMinimalPullRequest pullRequest;
    private final ApplicationUser user;
    private RescopeOutcome outcome;

    public SimplePullRequestRescope(@Nonnull SimpleMinimalPullRequest pullRequest, @Nonnull Date date, ApplicationUser user, @Nonnull String oldFromHash, @Nonnull String oldToHash, String newFromHash, String newToHash) {
        this.date = Objects.requireNonNull(date, "date");
        this.pullRequest = Objects.requireNonNull(pullRequest, "pullRequest");
        this.newFromHash = newFromHash;
        this.newToHash = newToHash;
        this.oldFromHash = Objects.requireNonNull(oldFromHash, "oldFromHash");
        this.oldToHash = Objects.requireNonNull(oldToHash, "oldToHash");
        this.user = user;
        if (newToHash == null) {
            this.outcome = new DeclineOutcome();
        }
    }

    @Nonnull
    public Date getDate() {
        return this.date;
    }

    @Nonnull
    public Repository getFromRepository() {
        return this.pullRequest.getFromRef().getRepository();
    }

    public String getNewFromHash() {
        return this.newFromHash;
    }

    public String getNewToHash() {
        return this.newToHash;
    }

    @Nonnull
    public String getOldFromHash() {
        return this.oldFromHash;
    }

    @Nonnull
    public String getOldToHash() {
        return this.oldToHash;
    }

    public RescopeOutcome getOutcome() {
        return this.outcome;
    }

    @Nonnull
    public SimpleMinimalPullRequest getPullRequest() {
        return this.pullRequest;
    }

    @Nonnull
    public Repository getToRepository() {
        return this.pullRequest.getToRef().getRepository();
    }

    @Nonnull
    public ApplicationUser getUser() {
        return this.user;
    }

    public void setOutcome(RescopeOutcome outcome) {
        this.outcome = outcome;
    }

    public String toString() {
        return "PullRequestRescope {pullRequest: " + this.pullRequest + ", user: " + this.user + ", from: " + this.oldFromHash + "->" + this.newFromHash + ", to: " + this.oldToHash + "->" + this.newToHash + "}";
    }
}

