/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.utils.process.BaseInputHandler;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UncheckedIOException;

public class LineInputHandler
extends BaseInputHandler
implements CommandInputHandler {
    private final Iterable<String> lines;

    public LineInputHandler(Iterable<String> lines) {
        this.lines = lines;
    }

    public void process(OutputStream input) {
        try (OutputStreamWriter writer = new OutputStreamWriter(input);){
            if (this.lines != null) {
                for (String line : this.lines) {
                    writer.write(line + "\n");
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

