/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.util.IoUtils;
import com.atlassian.utils.process.BaseOutputHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;

public class FileOutputHandler
extends BaseOutputHandler
implements CommandOutputHandler<Boolean> {
    private final File file;
    private long bytes;

    public FileOutputHandler(@Nonnull File file) {
        this.file = Objects.requireNonNull(file, "file");
    }

    @Nonnull
    public Boolean getOutput() {
        return this.bytes > 0L;
    }

    public void process(@Nonnull @WillClose InputStream inputStream) {
        try (InputStream ignored = inputStream;){
            this.bytes = IoUtils.copy((InputStream)inputStream, (File)this.file);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Output could not be copied to " + this.file.getAbsolutePath(), e);
        }
    }
}

