/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.util.IoUtils;
import com.atlassian.utils.process.BaseInputHandler;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.WillClose;

public class FileInputHandler
extends BaseInputHandler
implements CommandInputHandler {
    private final File file;

    public FileInputHandler(@Nonnull File file) {
        this.file = Objects.requireNonNull(file, "file");
    }

    public void process(@Nonnull @WillClose OutputStream outputStream) {
        try (OutputStream ignored = outputStream;){
            IoUtils.copy((File)this.file, (OutputStream)outputStream);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Input could not be copied from " + this.file.getAbsolutePath(), e);
        }
    }
}

