/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.io;

import com.atlassian.bitbucket.io.ByteBufferInputStream;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URLConnection;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.mozilla.universalchardet.UniversalDetector;

public class ContentDetectionUtils {
    @Nullable
    public static String detectContentType(@Nonnull ByteBuffer buffer, @Nullable String path) {
        try {
            return ContentDetectionUtils.detectContentType(new ByteBufferInputStream(Objects.requireNonNull(buffer, "buffer")), path);
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed reading from ByteBuffer", e);
        }
    }

    @Nullable
    public static String detectContentType(@Nonnull InputStream stream, @Nullable String path) throws IOException {
        String type = URLConnection.guessContentTypeFromStream(Objects.requireNonNull(stream, "stream"));
        if (StringUtils.isNotBlank((CharSequence)path)) {
            String pathType;
            if (type == null) {
                type = URLConnection.guessContentTypeFromName(path);
            } else if ("application/xml".equals(type) && StringUtils.isNotBlank((CharSequence)(pathType = URLConnection.guessContentTypeFromName(path))) && pathType.endsWith("+xml")) {
                type = pathType;
            }
        }
        return type;
    }

    @Nullable
    public static String detectEncoding(@Nonnull ByteBuffer buffer) {
        if (Objects.requireNonNull(buffer, "buffer").remaining() < 4) {
            return null;
        }
        byte[] buf = new byte[Math.min(buffer.remaining(), 4)];
        buffer.mark();
        buffer.get(buf);
        buffer.reset();
        UniversalDetector detector = new UniversalDetector(null);
        if (buf.length > 3) {
            detector.handleData(buf, 0, buf.length);
            if (detector.isDone()) {
                return detector.getDetectedCharset();
            }
            detector.reset();
        }
        if (buffer.hasArray()) {
            detector.handleData(buffer.array(), buffer.position(), buffer.remaining());
        } else {
            buf = ContentDetectionUtils.copyBuffer(buffer);
            detector.handleData(buf, 0, buf.length);
        }
        detector.dataEnd();
        return ContentDetectionUtils.getDetectedCharset(detector);
    }

    @Nullable
    public static String detectEncoding(@Nonnull InputStream stream, int bufferSize) throws IOException {
        Objects.requireNonNull(stream, "stream");
        Preconditions.checkArgument((boolean)stream.markSupported(), (Object)"Encoding detection requires a stream which supports mark/reset.");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Encoding detection requires a positive buffer size.");
        if (bufferSize < 4) {
            return null;
        }
        byte[] buf = new byte[4];
        stream.mark(5);
        int read = stream.read(buf);
        stream.reset();
        UniversalDetector detector = new UniversalDetector(null);
        if (read > 3) {
            detector.handleData(buf, 0, read);
            if (detector.isDone()) {
                return detector.getDetectedCharset();
            }
            detector.reset();
        }
        buf = new byte[bufferSize];
        stream.mark(buf.length);
        for (int remaining = buf.length; remaining > 0 && !detector.isDone() && (read = stream.read(buf, 0, remaining)) > 0; remaining -= read) {
            detector.handleData(buf, 0, read);
        }
        stream.reset();
        detector.dataEnd();
        return ContentDetectionUtils.getDetectedCharset(detector);
    }

    @Nullable
    public static String detectEncoding(@Nonnull byte[] buffer) {
        if (Objects.requireNonNull(buffer, "buffer").length < 4) {
            return null;
        }
        UniversalDetector detector = new UniversalDetector(null);
        detector.handleData(buffer, 0, buffer.length);
        detector.dataEnd();
        return ContentDetectionUtils.getDetectedCharset(detector);
    }

    public static boolean isBinary(@Nonnull ByteBuffer buffer) {
        if (!Objects.requireNonNull(buffer, "buffer").hasRemaining()) {
            return false;
        }
        if (buffer.hasArray()) {
            return ContentDetectionUtils.isBinary(buffer.array(), buffer.position() + buffer.arrayOffset(), buffer.remaining());
        }
        byte[] buf = ContentDetectionUtils.copyBuffer(buffer);
        return ContentDetectionUtils.isBinary(buf, 0, buf.length);
    }

    public static boolean isBinary(@Nonnull InputStream stream, int bufferSize) throws IOException {
        int b;
        Objects.requireNonNull(stream, "stream");
        Preconditions.checkArgument((boolean)stream.markSupported(), (Object)"Binary detection requires a stream which supports mark/reset.");
        Preconditions.checkArgument((bufferSize > 0 ? 1 : 0) != 0, (Object)"Binary detection requires a positive buffer size.");
        byte[] buf = new byte[4];
        stream.mark(5);
        int read = stream.read(buf);
        stream.reset();
        if (read > 3) {
            UniversalDetector detector = new UniversalDetector(null);
            detector.handleData(buf, 0, read);
            if (detector.isDone()) {
                return false;
            }
        }
        stream.mark(bufferSize);
        for (read = 0; read < bufferSize && (b = stream.read()) != -1; ++read) {
            if (b != 0) continue;
            stream.reset();
            return true;
        }
        stream.reset();
        return false;
    }

    public static boolean isBinary(@Nonnull byte[] buffer) {
        return ContentDetectionUtils.isBinary(buffer, 0, buffer.length);
    }

    private static byte[] copyBuffer(@Nonnull ByteBuffer buffer) {
        buffer.mark();
        try {
            byte[] buf = new byte[buffer.remaining()];
            buffer.get(buf);
            byte[] byArray = buf;
            return byArray;
        }
        finally {
            buffer.reset();
        }
    }

    private static String getDetectedCharset(UniversalDetector detector) {
        String encoding = detector.getDetectedCharset();
        if (encoding != null && Charset.isSupported(encoding)) {
            return encoding;
        }
        return null;
    }

    private static boolean isBinary(byte[] buffer, int offset, int count) {
        Objects.requireNonNull(buffer, "buffer");
        if (count > 3) {
            UniversalDetector detector = new UniversalDetector(null);
            detector.handleData(buffer, offset, 4);
            if (detector.isDone()) {
                return false;
            }
        }
        int end = offset + count;
        for (int i = offset; i < end; ++i) {
            if (buffer[i] != 0) continue;
            return true;
        }
        return false;
    }
}

