/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.home;

import com.atlassian.bitbucket.home.HomeUpdate;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleHomeUpdate
implements HomeUpdate {
    private final String newDir;
    private final String oldDir;

    private SimpleHomeUpdate(String newDir, String oldDir) {
        this.newDir = newDir;
        this.oldDir = oldDir;
    }

    @Nonnull
    public String getNewDir() {
        return this.newDir;
    }

    @Nonnull
    public String getOldDir() {
        return this.oldDir;
    }

    public static class Builder {
        private String newDir;
        private String oldDir;

        public Builder() {
        }

        public Builder(@Nonnull HomeUpdate update) {
            this.newDir = Objects.requireNonNull(update, "update").getNewDir();
            this.oldDir = update.getOldDir();
        }

        @Nonnull
        public SimpleHomeUpdate build() {
            Objects.requireNonNull(this.newDir, "newDir");
            Objects.requireNonNull(this.oldDir, "oldDir");
            return new SimpleHomeUpdate(this.newDir, this.oldDir);
        }

        @Nonnull
        public Builder newDir(@Nonnull String value) {
            this.newDir = Objects.requireNonNull(value, "value");
            return this;
        }

        @Nonnull
        public Builder oldDir(@Nonnull String value) {
            this.oldDir = Objects.requireNonNull(value, "value");
            return this;
        }
    }
}

