/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.ConflictMarker;
import com.atlassian.bitbucket.content.DiffLine;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleDiffLine
implements DiffLine {
    private final List<Long> commentIds;
    private final ConflictMarker conflictMarker;
    private final int destination;
    private final String line;
    private final int source;
    private final boolean truncated;

    private SimpleDiffLine(Builder builder) {
        this.commentIds = (List)Objects.requireNonNull(builder.commentIds.build(), "commentIds");
        this.conflictMarker = builder.conflictMarker;
        this.destination = builder.destination;
        this.line = builder.line;
        this.source = builder.source;
        this.truncated = builder.truncated;
    }

    @Nonnull
    public List<Long> getCommentIds() {
        return this.commentIds;
    }

    public ConflictMarker getConflictMarker() {
        return this.conflictMarker;
    }

    public int getDestination() {
        return this.destination;
    }

    @Nonnull
    public String getLine() {
        return this.line;
    }

    public int getSource() {
        return this.source;
    }

    public boolean isConflicting() {
        return this.conflictMarker != null;
    }

    public boolean isTruncated() {
        return this.truncated;
    }

    public static final class Builder {
        private ImmutableList.Builder<Long> commentIds = ImmutableList.builder();
        private ConflictMarker conflictMarker;
        private int destination;
        private String line;
        private int source;
        private boolean truncated;

        public Builder() {
        }

        public Builder(DiffLine diffLine) {
            this();
            this.destination = diffLine.getDestination();
            this.line = diffLine.getLine();
            this.source = diffLine.getSource();
            this.truncated = diffLine.isTruncated();
            this.commentIds.addAll((Iterable)diffLine.getCommentIds());
        }

        public SimpleDiffLine build() {
            return new SimpleDiffLine(this);
        }

        public Builder commentId(long value) {
            this.commentIds.add((Object)value);
            return this;
        }

        public Builder commentIds(long value, long ... values) {
            this.commentIds.add((Object)value);
            for (long v : values) {
                this.commentIds.add((Object)v);
            }
            return this;
        }

        public Builder commentIds(Iterable<Long> value) {
            if (value != null) {
                this.commentIds.addAll(value);
            }
            return this;
        }

        public Builder conflictMarker(ConflictMarker value) {
            this.conflictMarker = value;
            return this;
        }

        public Builder destination(int value) {
            this.destination = value;
            return this;
        }

        public Builder line(String value) {
            this.line = value;
            return this;
        }

        public Builder source(int value) {
            this.source = value;
            return this;
        }

        public Builder truncated(boolean value) {
            this.truncated = value;
            return this;
        }
    }
}

