/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.Conflict;
import com.atlassian.bitbucket.content.ConflictChange;
import java.util.Objects;
import javax.annotation.Nonnull;

public class SimpleConflict
implements Conflict {
    private final ConflictChange ourChange;
    private final ConflictChange theirChange;

    private SimpleConflict(ConflictChange ourChange, ConflictChange theirChange) {
        this.ourChange = ourChange;
        this.theirChange = theirChange;
    }

    @Nonnull
    public ConflictChange getOurChange() {
        return this.ourChange;
    }

    @Nonnull
    public ConflictChange getTheirChange() {
        return this.theirChange;
    }

    public String toString() {
        return "Our change: " + this.getOurChange() + ", their change: " + this.getTheirChange();
    }

    public static class Builder {
        private ConflictChange ourChange;
        private ConflictChange theirChange;

        public Builder() {
        }

        public Builder(Conflict conflict) {
            this.ourChange = conflict.getOurChange();
            this.theirChange = conflict.getTheirChange();
        }

        public SimpleConflict build() {
            Objects.requireNonNull(this.ourChange, "ourChange is required");
            Objects.requireNonNull(this.theirChange, "theirChange is required");
            return new SimpleConflict(this.ourChange, this.theirChange);
        }

        public Builder ourChange(ConflictChange value) {
            this.ourChange = Objects.requireNonNull(value, "ourChange");
            return this;
        }

        public Builder theirChange(ConflictChange value) {
            this.theirChange = Objects.requireNonNull(value, "theirChange");
            return this;
        }
    }
}

