/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.scm.ssh;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.scm.CommandExitHandler;
import com.atlassian.utils.process.ProcessTimeoutException;
import java.io.IOException;
import java.io.OutputStream;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshCommandExitHandler
implements CommandExitHandler {
    private static final Logger log = LoggerFactory.getLogger(SshCommandExitHandler.class);
    private final OutputStream errorStream;
    private final I18nService i18nService;
    private volatile Integer exitCode;

    public SshCommandExitHandler(I18nService i18nService, OutputStream errorStream) {
        this.errorStream = errorStream;
        this.i18nService = i18nService;
    }

    public Integer getExitCode() {
        return this.exitCode;
    }

    public void onCancel(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
        this.onExit(command, exitCode, stdErr, thrown);
    }

    public void onExit(@Nonnull String command, int exitCode, String stdErr, Throwable thrown) {
        this.exitCode = exitCode;
        if (thrown instanceof ProcessTimeoutException) {
            try {
                String message = this.i18nService.getMessage("bitbucket.scm.ssh.process.timeout", new Object[]{command});
                this.errorStream.write(message.getBytes());
                this.errorStream.flush();
            }
            catch (IOException e) {
                log.debug("{}: Failed to write timeout message to client", (Object)command, (Object)e);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("{}: (Exit code: {})", (Object)command, (Object)exitCode);
            if (thrown != null) {
                log.debug("{}: Threw the following exception:", thrown);
            }
        }
    }
}

