/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.repository;

import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.SimpleRef;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.Tag;
import javax.annotation.Nonnull;

public class SimpleTag
extends SimpleRef
implements Tag {
    private final String hash;

    private SimpleTag(@Nonnull Builder builder) {
        super(builder, (RefType)StandardRefType.TAG);
        this.hash = builder.hash;
    }

    public String getHash() {
        return this.hash;
    }

    @Override
    @Nonnull
    protected String fieldsToString() {
        return super.fieldsToString() + ", hash=" + this.getHash();
    }

    public static class Builder
    extends SimpleRef.AbstractRefBuilder<Builder, Tag> {
        private String hash;

        public Builder() {
        }

        public Builder(Tag ref) {
            super(ref);
            this.hash = ref.getHash();
        }

        @Nonnull
        public SimpleTag build() {
            return new SimpleTag(this);
        }

        public Builder hash(String value) {
            this.hash = value;
            return this;
        }

        @Nonnull
        protected Builder self() {
            return this;
        }
    }
}

