/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestRescopeOutcome;
import com.atlassian.bitbucket.scm.pull.PullRequestRescope;
import com.atlassian.bitbucket.util.ShaUtils;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class PullRequestRescopeAnalyzer {
    private final int maxCommitIds;
    private final PullRequestRescope rescope;
    private final String searchTarget;
    private boolean fromBranchDeleted;
    private boolean fromCommonAncestorFound;
    private boolean toCommonAncestorFound;
    private Set<String> oldFromHeads;
    private Set<String> oldToHeads;
    private Set<String> newFromHeads;
    private Set<String> newToHeads;
    private boolean anyInNewScope;
    private List<String> addedCommits;
    private List<String> removedCommits;
    private String mergeHash;
    private PullRequestRescopeOutcome outcome;
    private int addedCommitsCount;
    private int removedCommitsCount;

    public PullRequestRescopeAnalyzer(PullRequestRescope rescope, int maxCommitIds) {
        this.rescope = rescope;
        this.maxCommitIds = maxCommitIds;
        this.fromBranchDeleted = rescope.getNewFromHash() == null;
        String string = this.searchTarget = this.fromBranchDeleted ? rescope.getOldFromHash() : rescope.getNewFromHash();
        if (this.fromBranchDeleted && ShaUtils.hashesMatch((String)rescope.getOldToHash(), (String)rescope.getNewToHash())) {
            this.outcome = PullRequestRescopeOutcome.DECLINE;
        } else {
            this.outcome = PullRequestRescopeOutcome.UNKNOWN;
            this.fromCommonAncestorFound = ShaUtils.hashesMatch((String)rescope.getOldFromHash(), (String)rescope.getNewFromHash());
            this.toCommonAncestorFound = ShaUtils.hashesMatch((String)rescope.getOldToHash(), (String)rescope.getNewToHash());
            this.oldFromHeads = Sets.newHashSet((Object[])new String[]{rescope.getOldFromHash()});
            this.oldToHeads = Sets.newHashSet((Object[])new String[]{rescope.getOldToHash()});
            this.newFromHeads = this.fromBranchDeleted ? new HashSet() : Sets.newHashSet((Object[])new String[]{rescope.getNewFromHash()});
            this.newToHeads = Sets.newHashSet((Object[])new String[]{rescope.getNewToHash()});
        }
    }

    @Nonnull
    public List<String> getAddedCommits() {
        return this.addedCommits == null ? Collections.emptyList() : this.addedCommits;
    }

    public int getAddedCommitsCount() {
        return this.addedCommitsCount;
    }

    @Nullable
    public String getMergeHash() {
        return this.mergeHash;
    }

    @Nonnull
    public PullRequestRescopeOutcome getOutcome() {
        return this.outcome;
    }

    @Nonnull
    public List<String> getRemovedCommits() {
        return this.removedCommits == null ? Collections.emptyList() : this.removedCommits;
    }

    public boolean isDone() {
        return this.outcome != PullRequestRescopeOutcome.UNKNOWN;
    }

    public int getRemovedCommitsCount() {
        return this.removedCommitsCount;
    }

    public boolean onCommit(@Nonnull String commitId, @Nonnull Collection<String> parentIds) {
        if (this.isDone()) {
            return false;
        }
        boolean ancestorOfNewTo = PullRequestRescopeAnalyzer.processCommit(this.newToHeads, commitId, parentIds);
        if (ancestorOfNewTo && this.newToHeads.stream().anyMatch(head -> ShaUtils.hashesMatch((String)head, (String)this.searchTarget))) {
            if (ShaUtils.hashesMatch((String)commitId, (String)this.rescope.getNewToHash()) && parentIds.size() > 1) {
                this.mergeHash = commitId;
            }
            this.handleEmptyScope();
            return false;
        }
        boolean ancestorOfOldTo = PullRequestRescopeAnalyzer.processCommit(this.oldToHeads, commitId, parentIds);
        boolean ancestorOfOldFrom = PullRequestRescopeAnalyzer.processCommit(this.oldFromHeads, commitId, parentIds);
        boolean ancestorOfNewFrom = !this.fromBranchDeleted && PullRequestRescopeAnalyzer.processCommit(this.newFromHeads, commitId, parentIds);
        boolean inOldScope = ancestorOfOldFrom && !ancestorOfOldTo;
        boolean inNewScope = ancestorOfNewFrom && !ancestorOfNewTo;
        this.anyInNewScope |= inNewScope;
        if (inOldScope && !inNewScope && this.removedCommitsCount++ < this.maxCommitIds) {
            if (this.removedCommits == null) {
                this.removedCommits = new ArrayList<String>(this.maxCommitIds);
            }
            this.removedCommits.add(commitId);
        } else if (inNewScope && !inOldScope && this.addedCommitsCount++ < this.maxCommitIds) {
            if (this.addedCommits == null) {
                this.addedCommits = new ArrayList<String>(this.maxCommitIds);
            }
            this.addedCommits.add(commitId);
        }
        if (ancestorOfOldFrom || ancestorOfNewFrom || ancestorOfOldTo || ancestorOfNewTo) {
            if (!this.fromBranchDeleted && !this.fromCommonAncestorFound) {
                this.fromCommonAncestorFound = PullRequestRescopeAnalyzer.matches(this.oldFromHeads, this.newFromHeads);
            }
            if (!this.toCommonAncestorFound) {
                this.toCommonAncestorFound = PullRequestRescopeAnalyzer.matches(this.oldToHeads, this.newToHeads);
            }
            if (this.toCommonAncestorFound) {
                if (this.fromBranchDeleted && PullRequestRescopeAnalyzer.matches(this.oldFromHeads, this.newToHeads)) {
                    this.setOutcome(PullRequestRescopeOutcome.DECLINE);
                }
                if (!this.fromBranchDeleted && this.fromCommonAncestorFound) {
                    if (this.anyInNewScope || this.removedCommitsCount == 0) {
                        this.setOutcome(PullRequestRescopeOutcome.UPDATE);
                    } else if (this.isCommonAncestorFound()) {
                        this.handleEmptyScope();
                    }
                }
            }
        }
        return !this.isDone();
    }

    public PullRequestRescope getRescope() {
        return this.rescope;
    }

    private static boolean contains(Set<String> hashes, String value) {
        return hashes.stream().anyMatch(hash -> ShaUtils.hashesMatch((String)hash, (String)value));
    }

    private static boolean matches(Set<String> hashes1, Set<String> hashes2) {
        return hashes1.size() == hashes2.size() && hashes1.stream().allMatch(hash1 -> PullRequestRescopeAnalyzer.contains(hashes2, hash1));
    }

    private static boolean processCommit(Set<String> heads, String commitId, Collection<String> parentIds) {
        Iterator<String> it = heads.iterator();
        while (it.hasNext()) {
            String head = it.next();
            if (!ShaUtils.hashesMatch((String)head, (String)commitId)) continue;
            it.remove();
            heads.addAll(parentIds);
            return true;
        }
        return false;
    }

    private void handleEmptyScope() {
        if (ShaUtils.hashesMatch((String)this.rescope.getOldToHash(), (String)this.rescope.getNewToHash())) {
            this.setOutcome(PullRequestRescopeOutcome.DECLINE);
        } else {
            this.setOutcome(PullRequestRescopeOutcome.MERGE);
        }
    }

    private boolean isCommonAncestorFound() {
        return PullRequestRescopeAnalyzer.matches(this.newFromHeads, this.newToHeads);
    }

    private PullRequestRescopeOutcome setOutcome(PullRequestRescopeOutcome value) {
        this.outcome = value;
        if (this.outcome != PullRequestRescopeOutcome.UPDATE) {
            this.addedCommits = null;
            this.removedCommits = null;
            this.addedCommitsCount = 0;
            this.removedCommitsCount = 0;
        }
        this.oldFromHeads = null;
        this.oldToHeads = null;
        this.newFromHeads = null;
        this.newToHeads = null;
        return value;
    }
}

