/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestRescopeOutcome;
import com.atlassian.bitbucket.scm.pull.PullRequestRescope;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PullRequestRescopeAnalysisResult {
    private final List<String> addedCommits;
    private final int addedCommitsCount;
    private final String mergeHash;
    private final List<String> removedCommits;
    private final int removedCommitsCount;
    private final PullRequestRescopeOutcome outcome;
    private final PullRequestRescope rescope;

    private PullRequestRescopeAnalysisResult(Builder builder) {
        this.addedCommits = builder.addedCommits == null ? Collections.emptyList() : builder.addedCommits.build();
        this.addedCommitsCount = builder.addedCommitsCount;
        this.mergeHash = builder.mergeHash;
        this.removedCommits = builder.removedCommits == null ? Collections.emptyList() : builder.removedCommits.build();
        this.removedCommitsCount = builder.removedCommitsCount;
        this.outcome = builder.outcome;
        this.rescope = builder.rescope;
    }

    @Nonnull
    public List<String> getAddedCommits() {
        return this.addedCommits;
    }

    public int getAddedCommitsCount() {
        return this.addedCommitsCount;
    }

    @Nonnull
    public Optional<String> getMergeHash() {
        return Optional.ofNullable(this.mergeHash);
    }

    @Nonnull
    public List<String> getRemovedCommits() {
        return this.removedCommits;
    }

    public int getRemovedCommitsCount() {
        return this.removedCommitsCount;
    }

    @Nonnull
    public PullRequestRescopeOutcome getOutcome() {
        return this.outcome;
    }

    @Nonnull
    public PullRequestRescope getRescope() {
        return this.rescope;
    }

    public static class Builder {
        private final int maxCommitIds;
        private final PullRequestRescope rescope;
        private ImmutableList.Builder<String> addedCommits;
        private int addedCommitsCount;
        private String mergeHash;
        private PullRequestRescopeOutcome outcome;
        private ImmutableList.Builder<String> removedCommits;
        private int removedCommitsCount;

        public Builder(PullRequestRescope rescope, int maxCommitIds) {
            this.maxCommitIds = maxCommitIds;
            this.rescope = rescope;
            this.outcome = PullRequestRescopeOutcome.UNKNOWN;
        }

        @Nonnull
        public Builder addedCommit(@Nonnull String commitId) {
            if (++this.addedCommitsCount <= this.maxCommitIds) {
                if (this.addedCommits == null) {
                    this.addedCommits = ImmutableList.builder();
                }
                this.addedCommits.add((Object)commitId);
            }
            return this;
        }

        @Nonnull
        public PullRequestRescopeAnalysisResult build() {
            return new PullRequestRescopeAnalysisResult(this);
        }

        @Nonnull
        public Builder mergeHash(@Nullable String value) {
            this.mergeHash = value;
            return this;
        }

        @Nonnull
        public Builder outcome(@Nullable PullRequestRescopeOutcome value) {
            this.outcome = value == null ? PullRequestRescopeOutcome.UNKNOWN : value;
            return this;
        }

        @Nonnull
        public Builder removedCommit(@Nonnull String commitId) {
            if (++this.removedCommitsCount <= this.maxCommitIds) {
                if (this.removedCommits == null) {
                    this.removedCommits = ImmutableList.builder();
                }
                this.removedCommits.add((Object)commitId);
            }
            return this;
        }
    }
}

