/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.pull;

import com.atlassian.bitbucket.pull.PullRequestRescopeAnalysisResult;
import com.atlassian.bitbucket.pull.PullRequestRescopeOutcome;
import com.atlassian.bitbucket.scm.pull.PullRequestRescope;
import com.atlassian.bitbucket.util.ShaUtils;
import com.atlassian.bitbucket.util.SortedShaSet;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class BulkPullRequestRescopeAnalyzer {
    private final PullRequestRescopeAnalysisContext analysisContext;
    private final List<SinglePullRequestRescopeAnalyzer> analyzers;
    private final List<PullRequestRescopeAnalysisResult> results;

    private BulkPullRequestRescopeAnalyzer(Builder builder) {
        this.analysisContext = new PullRequestRescopeAnalysisContext(builder.maxCommitIds);
        this.analyzers = builder.rescopes.stream().map(rescope -> new SinglePullRequestRescopeAnalyzer((PullRequestRescope)rescope, this.analysisContext)).collect(Collectors.toList());
        this.results = new ArrayList<PullRequestRescopeAnalysisResult>();
    }

    public void close() {
        for (SinglePullRequestRescopeAnalyzer analyzer : this.analyzers) {
            this.results.add(analyzer.getResult());
        }
        this.analyzers.clear();
    }

    @Nonnull
    public List<PullRequestRescopeAnalysisResult> getResults() {
        if (this.analyzers.isEmpty()) {
            return Collections.unmodifiableList(this.results);
        }
        return ImmutableList.builder().addAll(this.results).addAll((Iterable)this.analyzers.stream().map(SinglePullRequestRescopeAnalyzer::getResult).collect(Collectors.toList())).build();
    }

    public boolean onCommit(@Nonnull String commitId, @Nonnull String[] parentIds) {
        this.analysisContext.onCommit(commitId, parentIds);
        int remainingAnalyzers = 0;
        Iterator<SinglePullRequestRescopeAnalyzer> it = this.analyzers.iterator();
        while (it.hasNext()) {
            SinglePullRequestRescopeAnalyzer analyzer = it.next();
            if (analyzer.onCommit(commitId, parentIds)) {
                ++remainingAnalyzers;
                continue;
            }
            it.remove();
            this.results.add(analyzer.getResult());
        }
        return remainingAnalyzers > 0;
    }

    @NotThreadSafe
    private static class SinglePullRequestRescopeAnalyzer {
        private final PullRequestRescope rescope;
        private final String searchTarget;
        private boolean anyInNewScope;
        private boolean anyRemoved;
        private boolean fromBranchDeleted;
        private boolean fromCommonAncestorFound;
        private boolean toCommonAncestorFound;
        private AncestorTrackerStub oldFromAncestors;
        private AncestorTrackerStub oldToAncestors;
        private AncestorTrackerStub newFromAncestors;
        private AncestorTrackerStub newToAncestors;
        private PullRequestRescopeAnalysisResult.Builder resultBuilder;
        private PullRequestRescopeAnalysisResult result;

        SinglePullRequestRescopeAnalyzer(PullRequestRescope rescope, PullRequestRescopeAnalysisContext context) {
            this.rescope = rescope;
            this.resultBuilder = new PullRequestRescopeAnalysisResult.Builder(rescope, context.getMaxCommitIds());
            this.fromBranchDeleted = rescope.getNewFromHash() == null;
            String string = this.searchTarget = this.fromBranchDeleted ? rescope.getOldFromHash() : rescope.getNewFromHash();
            if (this.fromBranchDeleted && ShaUtils.hashesMatch((String)rescope.getOldToHash(), (String)rescope.getNewToHash())) {
                this.setResult(PullRequestRescopeOutcome.DECLINE);
            } else if (rescope.getNewToHash() == null) {
                this.setResult(PullRequestRescopeOutcome.DECLINE);
            } else {
                this.oldFromAncestors = context.openTracker(rescope.getOldFromHash());
                this.oldToAncestors = context.openTracker(rescope.getOldToHash());
                this.newFromAncestors = rescope.getNewFromHash() == null ? null : context.openTracker(rescope.getNewFromHash());
                this.newToAncestors = context.openTracker(rescope.getNewToHash());
                this.fromCommonAncestorFound = this.oldFromAncestors.equals(this.newFromAncestors);
                this.toCommonAncestorFound = this.oldToAncestors.equals(this.newToAncestors);
            }
        }

        public boolean isDone() {
            return this.result != null;
        }

        public boolean onCommit(@Nonnull String commitId, @Nonnull String[] parentIds) {
            if (this.isDone()) {
                return false;
            }
            boolean ancestorOfNewTo = this.newToAncestors.isUpdated();
            if (ancestorOfNewTo && SinglePullRequestRescopeAnalyzer.matchesAny(this.searchTarget, parentIds)) {
                if (ShaUtils.hashesMatch((String)commitId, (String)this.rescope.getNewToHash()) && parentIds.length > 1) {
                    this.resultBuilder.mergeHash(commitId);
                }
                this.handleEmptyScope();
                return false;
            }
            boolean ancestorOfOldTo = this.oldToAncestors.isUpdated();
            boolean ancestorOfOldFrom = this.oldFromAncestors.isUpdated();
            boolean ancestorOfNewFrom = !this.fromBranchDeleted && this.newFromAncestors.isUpdated();
            boolean inOldScope = ancestorOfOldFrom && !ancestorOfOldTo;
            boolean inNewScope = ancestorOfNewFrom && !ancestorOfNewTo;
            this.anyInNewScope |= inNewScope;
            if (inOldScope && !inNewScope) {
                this.anyRemoved = true;
                this.resultBuilder.removedCommit(commitId);
            } else if (inNewScope && !inOldScope) {
                this.resultBuilder.addedCommit(commitId);
            }
            if (ancestorOfOldFrom || ancestorOfNewFrom || ancestorOfOldTo || ancestorOfNewTo) {
                if (!this.fromBranchDeleted && !this.fromCommonAncestorFound) {
                    this.fromCommonAncestorFound = this.oldFromAncestors.equals(this.newFromAncestors);
                }
                if (!this.toCommonAncestorFound) {
                    this.toCommonAncestorFound = this.oldToAncestors.equals(this.newToAncestors);
                }
                if (this.toCommonAncestorFound) {
                    if (this.fromBranchDeleted && this.oldFromAncestors.equals(this.newToAncestors)) {
                        this.setResult(PullRequestRescopeOutcome.DECLINE);
                    }
                    if (!this.fromBranchDeleted && this.fromCommonAncestorFound) {
                        if (this.anyInNewScope || !this.anyRemoved) {
                            this.setResult(PullRequestRescopeOutcome.UPDATE);
                        } else if (this.isCommonAncestorFound()) {
                            this.handleEmptyScope();
                        }
                    }
                }
            }
            return !this.isDone();
        }

        public PullRequestRescope getRescope() {
            return this.rescope;
        }

        @Nonnull
        public PullRequestRescopeAnalysisResult getResult() {
            return this.result != null ? this.result : this.resultBuilder.build();
        }

        private static boolean matchesAny(String hash, String[] hashes) {
            for (String h : hashes) {
                if (!ShaUtils.hashesMatch((String)h, (String)hash)) continue;
                return true;
            }
            return false;
        }

        private void handleEmptyScope() {
            if (ShaUtils.hashesMatch((String)this.rescope.getOldToHash(), (String)this.rescope.getNewToHash())) {
                this.setResult(PullRequestRescopeOutcome.DECLINE);
            } else {
                this.setResult(PullRequestRescopeOutcome.MERGE);
            }
        }

        private boolean isCommonAncestorFound() {
            return this.newFromAncestors.equals(this.newToAncestors);
        }

        private void setResult(PullRequestRescopeOutcome outcome) {
            this.result = this.resultBuilder.outcome(outcome).build();
            this.resultBuilder = null;
            if (this.oldFromAncestors != null) {
                this.oldFromAncestors.close();
            }
            if (this.oldToAncestors != null) {
                this.oldToAncestors.close();
            }
            if (this.newFromAncestors != null) {
                this.newFromAncestors.close();
            }
            if (this.newToAncestors != null) {
                this.newToAncestors.close();
            }
            this.oldFromAncestors = null;
            this.oldToAncestors = null;
            this.newFromAncestors = null;
            this.newToAncestors = null;
        }
    }

    private static class PullRequestRescopeAnalysisContext {
        private final int maxCommitIds;
        private final Map<String, AncestorTracker> trackers;

        PullRequestRescopeAnalysisContext(int maxCommitIds) {
            this.maxCommitIds = maxCommitIds;
            this.trackers = new HashMap<String, AncestorTracker>();
        }

        @Nonnull
        AncestorTrackerStub openTracker(@Nonnull String commitId) {
            AncestorTracker tracker = this.trackers.computeIfAbsent(commitId, AncestorTracker::new);
            return tracker.open();
        }

        void onCommit(@Nonnull String commitId, @Nonnull String[] parentIds) {
            Iterator<AncestorTracker> it = this.trackers.values().iterator();
            while (it.hasNext()) {
                AncestorTracker tracker = it.next();
                if (tracker.isOpen()) {
                    tracker.onCommit(commitId, parentIds);
                    continue;
                }
                it.remove();
            }
        }

        int getMaxCommitIds() {
            return this.maxCommitIds;
        }
    }

    private static class AncestorTrackerStub {
        private AncestorTracker tracker;

        private AncestorTrackerStub(AncestorTracker tracker) {
            this.tracker = tracker;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AncestorTrackerStub that = (AncestorTrackerStub)o;
            return Objects.equals(this.tracker, that.tracker);
        }

        public int hashCode() {
            return this.tracker.hashCode();
        }

        void close() {
            if (this.tracker != null) {
                this.tracker.close();
                this.tracker = null;
            }
        }

        boolean isUpdated() {
            return this.get().isUpdated();
        }

        private AncestorTracker get() {
            if (this.tracker == null) {
                throw new IllegalStateException("AncestorTracker has already been closed");
            }
            return this.tracker;
        }
    }

    private static class AncestorTracker {
        private int openCount = -1;
        private SortedShaSet heads = new SortedShaSet();
        private boolean updated;

        AncestorTracker(String commitId) {
            this.heads.add(commitId);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            AncestorTracker that = (AncestorTracker)o;
            return Objects.equals(this.heads, that.heads);
        }

        public int hashCode() {
            return Objects.hash(this.heads);
        }

        void close() {
            if (--this.openCount == 0) {
                this.heads = null;
            }
        }

        boolean isOpen() {
            return this.openCount > 0;
        }

        boolean isUpdated() {
            return this.updated;
        }

        void onCommit(@Nonnull String commitId, String ... parentIds) {
            this.updated = this.heads.remove(commitId);
            if (this.updated) {
                for (String parentId : parentIds) {
                    this.heads.add(parentId);
                }
            }
        }

        AncestorTrackerStub open() {
            this.openCount = this.openCount == -1 ? 1 : this.openCount + 1;
            return new AncestorTrackerStub(this);
        }
    }

    public static class Builder {
        private int maxCommitIds;
        private List<PullRequestRescope> rescopes;

        public Builder(int maxCommitIds) {
            this.maxCommitIds = maxCommitIds;
            this.rescopes = new ArrayList<PullRequestRescope>();
        }

        public BulkPullRequestRescopeAnalyzer build() {
            return new BulkPullRequestRescopeAnalyzer(this);
        }

        @Nonnull
        public Builder rescope(@Nonnull PullRequestRescope rescope) {
            this.rescopes.add(Objects.requireNonNull(rescope, "rescope"));
            return this;
        }
    }
}

