/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.content;

import com.atlassian.bitbucket.content.Path;
import com.atlassian.bitbucket.content.SimplePath;
import com.atlassian.bitbucket.content.Submodule;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleSubmodule
extends Submodule {
    private final String contentId;
    private final Path path;
    private final String url;
    private final String repositoryUrl;
    private final String browseUrl;

    private SimpleSubmodule(Builder builder) {
        this.browseUrl = builder.browseUrl;
        this.contentId = builder.contentId;
        this.path = builder.path;
        this.repositoryUrl = builder.repositoryUrl;
        this.url = builder.url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof SimpleSubmodule) {
            SimpleSubmodule f = (SimpleSubmodule)((Object)o);
            return this.getPath().equals(f.getPath()) && Objects.equal((Object)this.getContentId(), (Object)f.getContentId());
        }
        return false;
    }

    public String getBrowseUrl() {
        return this.browseUrl;
    }

    public String getContentId() {
        return this.contentId;
    }

    @Nonnull
    public Path getPath() {
        return this.path;
    }

    public String getRepositoryUrl() {
        return this.repositoryUrl;
    }

    @Nonnull
    public String getUrl() {
        return this.url;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getPath(), this.getContentId()});
    }

    public String toString() {
        return "SimpleSubmodule{path='" + this.path + '\'' + ", contentId='" + this.contentId + '\'' + ", url='" + this.url + '\'' + ", repositoryUrl='" + this.repositoryUrl + '\'' + ", browseUrl='" + this.browseUrl + '\'' + '}';
    }

    public static class Builder {
        private String contentId;
        private Path path;
        private String url;
        private String repositoryUrl;
        private String browseUrl;

        public Builder() {
        }

        public Builder(@Nonnull Submodule submodule) {
            this.path(((Submodule)Preconditions.checkNotNull((Object)submodule, (Object)"submodule")).getPath());
            this.contentId(submodule.getContentId());
            this.url(submodule.getUrl());
            this.repositoryUrl(submodule.getRepositoryUrl());
            this.browseUrl(submodule.getBrowseUrl());
        }

        @Nonnull
        public Builder browseUrl(@Nullable String value) {
            this.browseUrl = value;
            return this;
        }

        @Nonnull
        public SimpleSubmodule build() {
            Preconditions.checkState((this.path != null ? 1 : 0) != 0, (Object)"A path is required.");
            Preconditions.checkState((this.url != null ? 1 : 0) != 0, (Object)"A URL is required.");
            return new SimpleSubmodule(this);
        }

        @Nonnull
        public Builder contentId(@Nullable String value) {
            this.contentId = value;
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull Path value) {
            this.path = (Path)Preconditions.checkNotNull((Object)value, (Object)"path");
            return this;
        }

        @Nonnull
        public Builder path(@Nonnull String value) {
            return this.path((Path)new SimplePath((CharSequence)Preconditions.checkNotNull((Object)value, (Object)"path")));
        }

        @Nonnull
        public Builder repositoryUrl(@Nullable String value) {
            this.repositoryUrl = value;
            return this;
        }

        @Nonnull
        public Builder url(@Nonnull String value) {
            this.url = (String)Preconditions.checkNotNull((Object)value, (Object)"url");
            return this;
        }
    }
}

