/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.util;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.google.common.base.Preconditions;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;

public class RestPermissionUtils {
    private RestPermissionUtils() {
        throw new UnsupportedOperationException(RestPermissionUtils.class.getName() + " should not be instantiated");
    }

    @Nullable
    public static Permission parsePermission(@Nonnull I18nService i18nService, @Nullable String permission, @Nullable Class<?> resourceType) {
        return RestPermissionUtils.parsePermission(i18nService, permission, resourceType, null, null);
    }

    @Nullable
    public static Permission parsePermission(@Nonnull I18nService i18nService, @Nullable String permission, @Nullable Class<?> resourceType, @Nullable Permission defaultPermission, @Nullable String context) {
        Preconditions.checkNotNull((Object)i18nService, (Object)"i18nService");
        if (StringUtils.isNotBlank((String)permission)) {
            Permission permissionLevel;
            try {
                permissionLevel = Permission.valueOf((String)permission.toUpperCase(Locale.US));
            }
            catch (IllegalArgumentException e) {
                throw new BadRequestException(context, i18nService.getMessage("stash.rest.permission.invalid", new Object[]{permission}));
            }
            if (resourceType == null || permissionLevel.isResource(resourceType)) {
                return permissionLevel;
            }
            throw new BadRequestException(context, i18nService.getMessage("stash.rest.permission.invalidresource", new Object[]{permissionLevel, resourceType.getSimpleName()}));
        }
        return defaultPermission;
    }
}

