/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.renderer;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.stash.internal.rest.renderer.DefaultSurrogateBuilder;
import com.atlassian.stash.internal.rest.renderer.SurrogateBuilder;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class AggregateBuilder
implements SurrogateBuilder {
    private static final Logger log = LoggerFactory.getLogger(AggregateBuilder.class);
    protected final Map<Class<?>, SurrogateBuilder> surrogates;
    protected final NavBuilder navBuilder;

    public AggregateBuilder(NavBuilder navBuilder) {
        this.navBuilder = navBuilder;
        this.surrogates = Maps.newHashMap();
        this.addSurrogateBuilder(Collection.class, new CollectionSurrogateBuilder());
        this.addSurrogateBuilder(Map.class, new MapSurrogateBuilder());
        this.addSurrogateBuilder(Page.class, new PageSurrogateBuilder());
    }

    public void addSurrogateBuilder(Class<?> targetClass, SurrogateBuilder builder) {
        this.surrogates.put(targetClass, builder);
    }

    @Override
    public Object buildFor(final Object object) {
        if (object == null) {
            return object;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass.getPackage() == null) {
            return null;
        }
        if ("java.lang".equals(objectClass.getPackage().getName())) {
            return object;
        }
        ArrayList potentialSurrogates = Lists.newArrayList((Iterable)Sets.filter(this.surrogates.entrySet(), (Predicate)new Predicate<Map.Entry<Class<?>, SurrogateBuilder>>(){

            public boolean apply(Map.Entry<Class<?>, SurrogateBuilder> entry) {
                return entry.getKey().isInstance(object);
            }
        }));
        if (!potentialSurrogates.isEmpty()) {
            if (potentialSurrogates.size() > 1) {
                Collections.sort(potentialSurrogates, new Comparator<Map.Entry<Class<?>, SurrogateBuilder>>(){

                    @Override
                    public int compare(Map.Entry<Class<?>, SurrogateBuilder> lhs, Map.Entry<Class<?>, SurrogateBuilder> rhs) {
                        return rhs.getKey().isAssignableFrom(lhs.getKey()) ? -1 : (lhs.getKey().isAssignableFrom(rhs.getKey()) ? 1 : 0);
                    }
                });
            }
            try {
                return ((SurrogateBuilder)((Map.Entry)potentialSurrogates.get(0)).getValue()).buildFor(object);
            }
            catch (Exception e) {
                log.error(String.format("Failed to create the JSON surrogate for an object of type %s", objectClass.getName()), (Throwable)e);
            }
        } else {
            log.trace("Unable to find a JSON surrogate for an object of type {}", (Object)objectClass.getName());
        }
        return object;
    }

    public void registerSurrogate(@Nonnull Class<?> surrogateClass) {
        JsonSurrogate surrogateInfo = surrogateClass.getAnnotation(JsonSurrogate.class);
        if (surrogateInfo == null) {
            throw new IllegalArgumentException(String.format("Cannot add %s as a surrogate - it is not annotated with %s", surrogateClass.getName(), JsonSurrogate.class.getName()));
        }
        SurrogateBuilder surrogateBuilder = this.createSurrogate(surrogateClass, surrogateInfo.value());
        if (surrogateBuilder == null) {
            throw new IllegalArgumentException(String.format("Cannot add %s as a surrogate - it does not have an appropriate constructor", surrogateClass.getName()));
        }
        this.addSurrogateBuilder(surrogateInfo.value(), surrogateBuilder);
    }

    protected SurrogateBuilder createSurrogate(Class<?> surrogateClass, Class<?> targetClass) {
        Constructor ctor = ClassUtils.getConstructorIfAvailable(surrogateClass, (Class[])new Class[]{targetClass, NavBuilder.class});
        if (ctor != null) {
            return new DefaultSurrogateBuilder(ctor, this.navBuilder);
        }
        ctor = ClassUtils.getConstructorIfAvailable(surrogateClass, (Class[])new Class[]{targetClass});
        if (ctor != null) {
            return new DefaultSurrogateBuilder(ctor, new Object[0]);
        }
        return null;
    }

    public class PageSurrogateBuilder
    implements SurrogateBuilder {
        @Override
        public Object buildFor(Object object) {
            return new RestPage((Page)object, new Function(){

                public Object apply(Object element) {
                    return AggregateBuilder.this.buildFor(element);
                }
            });
        }
    }

    public class MapSurrogateBuilder
    implements SurrogateBuilder {
        @Override
        public Object buildFor(Object object) {
            return Maps.newLinkedHashMap((Map)Maps.transformValues((Map)((Map)object), (Function)new Function(){

                public Object apply(Object value) {
                    return AggregateBuilder.this.buildFor(value);
                }
            }));
        }
    }

    public class CollectionSurrogateBuilder
    implements SurrogateBuilder {
        @Override
        public Object buildFor(Object object) {
            return Lists.newArrayList((Iterable)Collections2.transform((Collection)((Collection)object), (Function)new Function(){

                public Object apply(Object element) {
                    return AggregateBuilder.this.buildFor(element);
                }
            }));
        }
    }
}

