/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.comment.Comment;
import com.atlassian.bitbucket.content.DiffContentCallback;
import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.bitbucket.content.DiffWhitespace;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestDiffRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.rest.comment.RestComment;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.content.JsonDiffContentCallback;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.google.common.base.Function;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/diff")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestDiffResource
extends AbstractPullRequestResource {
    private final AvatarEnricher avatarEnricher;

    public PullRequestDiffResource(I18nService i18nService, PullRequestService pullRequestService, AvatarEnricher avatarEnricher) {
        super(i18nService, pullRequestService);
        this.avatarEnricher = avatarEnricher;
    }

    @GET
    @Path(value="{path:.*}")
    public Response streamDiff(@Context PullRequest pullRequest, @PathParam(value="path") String path, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="srcPath") String srcPath, @QueryParam(value="whitespace") String whitespace, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, @Context DiffContentFilter filter, @Context ContainerRequest request) {
        final PullRequestDiffRequest diffRequest = new PullRequestDiffRequest.Builder(pullRequest, path).contextLines(contextLines).filter(filter).srcPath(srcPath).whitespace(DiffWhitespace.fromString((String)whitespace)).withComments(withComments).build();
        final Function<Comment, RestComment> commentTransformer = this.createAvatarCommentTransformer(request);
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                PullRequestDiffResource.this.pullRequestService.streamDiff(diffRequest, (DiffContentCallback)new JsonDiffContentCallback(writer, (Function<Comment, RestComment>)commentTransformer));
            }
        }, CachePolicies.noCache()).build();
    }

    @GET
    public Response streamDiff(@Context PullRequest pullRequest, @QueryParam(value="contextLines") @DefaultValue(value="-1") int contextLines, @QueryParam(value="srcPath") String sourcePath, @QueryParam(value="whitespace") String whitespace, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, @Context DiffContentFilter filter, @Context ContainerRequest request) {
        return this.streamDiff(pullRequest, null, contextLines, sourcePath, whitespace, withComments, filter, request);
    }

    private Function<Comment, RestComment> createAvatarCommentTransformer(ContainerRequest request) {
        final AvatarRequest avatarRequest = RestUtils.makeAvatarRequest(request);
        if (avatarRequest == null) {
            return RestComment.REST_TRANSFORM;
        }
        return new Function<Comment, RestComment>(){

            public RestComment apply(Comment comment) {
                RestComment restComment = new RestComment(comment, this);
                PullRequestDiffResource.this.avatarEnricher.enrich(restComment, avatarRequest);
                return restComment;
            }
        };
    }
}

