/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.content.ChangeCallback;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestChangesRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.rest.util.CachePolicies;
import com.atlassian.bitbucket.rest.util.JsonStreamingOutput;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.rest.util.StatefulJsonWriter;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.stash.internal.rest.content.JsonChangeCallback;
import com.atlassian.stash.internal.rest.pull.AbstractPullRequestResource;
import com.sun.jersey.spi.resource.Singleton;
import java.io.IOException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/pull-requests/{pullRequestId}/changes")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class PullRequestChangeResource
extends AbstractPullRequestResource {
    public PullRequestChangeResource(I18nService i18nService, PullRequestService pullRequestService) {
        super(i18nService, pullRequestService);
    }

    @GET
    public Response streamChanges(@Context PullRequest pullRequest, @QueryParam(value="withComments") @DefaultValue(value="true") boolean withComments, final @Context PageRequest pageRequest) {
        final PullRequestChangesRequest request = new PullRequestChangesRequest.Builder(pullRequest).withComments(withComments).build();
        return ResponseFactory.ok(new JsonStreamingOutput(){

            @Override
            public void write(StatefulJsonWriter writer) throws IOException, WebApplicationException {
                PullRequestChangeResource.this.pullRequestService.streamChanges(request, (ChangeCallback)new JsonChangeCallback(writer, pageRequest));
            }
        }, CachePolicies.noCache()).build();
    }
}

