/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.pull;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.rest.BadRequestException;
import com.atlassian.bitbucket.rest.RestResource;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractPullRequestResource
extends RestResource {
    protected final PullRequestService pullRequestService;

    protected AbstractPullRequestResource(I18nService i18nService, PullRequestService pullRequestService) {
        super(i18nService);
        this.pullRequestService = pullRequestService;
    }

    @Nonnull
    protected <T> T ensureHasProperty(@Nonnull String propertyName, @Nullable T value) {
        if (value == null) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.pullrequests.property.notsupplied", new Object[]{propertyName}));
        }
        return value;
    }

    protected void ensurePropertySupplied(@Nonnull String fieldName, boolean supplied) {
        if (!supplied) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.pullrequests.property.notsupplied", new Object[]{fieldName}));
        }
    }

    protected void ensurePropertyNotSupplied(@Nonnull String fieldName, boolean supplied) {
        if (supplied) {
            throw new BadRequestException(this.i18nService.getMessage("stash.rest.pullrequests.property.supplied", new Object[]{fieldName}));
        }
    }
}

