/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.atlassian.stash.internal.rest.util.HttpContextUtils;
import com.sun.jersey.api.core.HttpContext;
import javax.annotation.Nonnull;

public class ProjectInjectable
extends AbstractResourceInjectable<Project> {
    private final I18nService i18nService;
    private final ProjectService projectService;

    public ProjectInjectable(I18nService i18nService, ProjectService projectService) {
        this.i18nService = i18nService;
        this.projectService = projectService;
    }

    @Override
    @Nonnull
    public Project doGetValue(HttpContext httpContext) {
        String projectKey = HttpContextUtils.requireSinglePathSegmentValue("projectKey", httpContext, Project.class);
        Project project = this.projectService.getByKey(projectKey);
        if (project == null) {
            throw new NoSuchProjectException(this.i18nService.createKeyedMessage("stash.rest.nosuchproject", new Object[]{projectKey}));
        }
        return project;
    }
}

