/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.inject;

import com.atlassian.bitbucket.content.DiffContentFilter;
import com.atlassian.stash.internal.rest.inject.AbstractResourceInjectable;
import com.sun.jersey.api.core.HttpContext;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.ws.rs.core.MultivaluedMap;
import org.apache.commons.lang.StringUtils;

public class DiffContentFilterInjectable
extends AbstractResourceInjectable<DiffContentFilter> {
    private static DiffContentFilter createFilter(String text, final boolean caseSensitive) {
        final String filter = caseSensitive ? text : text.toLowerCase(Locale.US);
        return new DiffContentFilter(){

            public boolean apply(@Nonnull String input) {
                if (!caseSensitive) {
                    return input.toLowerCase(Locale.US).contains(filter);
                }
                return input.contains(filter);
            }
        };
    }

    @Override
    public DiffContentFilter doGetValue(HttpContext httpContext) {
        MultivaluedMap queryParameters = httpContext.getRequest().getQueryParameters();
        String filter = StringUtils.trimToNull((String)((String)queryParameters.getFirst((Object)"filter")));
        return filter != null ? DiffContentFilterInjectable.createFilter(filter, "true".equalsIgnoreCase((String)queryParameters.getFirst((Object)"caseSensitive"))) : null;
    }
}

