/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.exception;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.EntityOutOfDateException;
import com.atlassian.bitbucket.FeatureDisabledException;
import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.IllegalEntityStateException;
import com.atlassian.bitbucket.IntegrityException;
import com.atlassian.bitbucket.NoSuchEntityException;
import com.atlassian.bitbucket.RequestCanceledException;
import com.atlassian.bitbucket.ServiceException;
import com.atlassian.bitbucket.auth.AuthenticationRequiredException;
import com.atlassian.bitbucket.license.IncompatibleLicenseChangeException;
import com.atlassian.bitbucket.license.InvalidLicenseException;
import com.atlassian.bitbucket.license.LicenseLimitException;
import com.atlassian.bitbucket.license.LimitExceededException;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.pull.DuplicatePullRequestException;
import com.atlassian.bitbucket.pull.InvalidPullRequestReviewersException;
import com.atlassian.bitbucket.pull.PullRequestMergeVetoedException;
import com.atlassian.bitbucket.pull.UnmodifiablePullRequestRoleException;
import com.atlassian.bitbucket.rest.RestEntityOutOfDateErrorMessage;
import com.atlassian.bitbucket.rest.RestErrorMessage;
import com.atlassian.bitbucket.rest.RestErrors;
import com.atlassian.bitbucket.rest.RestRequestCanceledMessage;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.auth.RestAuthenticationRequiredErrorMessage;
import com.atlassian.bitbucket.rest.pull.RestDuplicatePullRequestErrorMessage;
import com.atlassian.bitbucket.rest.pull.RestInvalidPullRequestReviewersErrorMessage;
import com.atlassian.bitbucket.rest.pull.RestPullRequestMergeVetoedErrorMessage;
import com.atlassian.bitbucket.rest.pull.RestPullRequestOutOfDateErrorMessage;
import com.atlassian.bitbucket.rest.repository.RestDuplicateRefMessage;
import com.atlassian.bitbucket.rest.repository.RestInvalidRefNameMessage;
import com.atlassian.bitbucket.rest.scm.RestMergeErrorMessage;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.scm.MergeException;
import com.atlassian.bitbucket.util.PageStartOutOfBoundsException;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.stash.internal.rest.renderer.AggregateBuilder;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ServiceExceptionMapper
implements ExceptionMapper<ServiceException> {
    public static final Map<Class<? extends ServiceException>, Response.Status> STATUS_MAP;
    private static final Logger log;
    private final AggregateBuilder exceptionMessageBuilder;

    public ServiceExceptionMapper(NavBuilder navBuilder) {
        this.exceptionMessageBuilder = new AggregateBuilder(navBuilder);
        this.registerSurrogate(RestAuthenticationRequiredErrorMessage.class);
        this.registerSurrogate(RestDuplicatePullRequestErrorMessage.class);
        this.registerSurrogate(RestEntityOutOfDateErrorMessage.class);
        this.registerSurrogate(RestErrorMessage.class);
        this.registerSurrogate(RestInvalidPullRequestReviewersErrorMessage.class);
        this.registerSurrogate(RestMergeErrorMessage.class);
        this.registerSurrogate(RestPullRequestMergeVetoedErrorMessage.class);
        this.registerSurrogate(RestPullRequestOutOfDateErrorMessage.class);
        this.registerSurrogate(RestRequestCanceledMessage.class);
        this.registerSurrogate(RestDuplicateRefMessage.class);
        this.registerSurrogate(RestInvalidRefNameMessage.class);
    }

    public Response toResponse(ServiceException e) {
        RestErrors errors = new RestErrors((RestErrorMessage)this.exceptionMessageBuilder.buildFor(e));
        Response response = this.createResponseBuilder(e).entity((Object)errors).type("application/json;charset=UTF-8").build();
        log.debug("Mapping ServiceException to REST response " + response.getStatus(), (Throwable)e);
        return response;
    }

    private void registerSurrogate(Class<? extends RestErrorMessage> surrogateClass) {
        Preconditions.checkArgument((boolean)surrogateClass.isAnnotationPresent(JsonSurrogate.class), (Object)(surrogateClass.getName() + " is not annotated as a surrogate"));
        Preconditions.checkArgument((boolean)RestErrorMessage.class.isAssignableFrom(surrogateClass), (Object)(surrogateClass.getName() + " must derive from RestErrorMessage"));
        Preconditions.checkArgument((boolean)ServiceException.class.isAssignableFrom(surrogateClass.getAnnotation(JsonSurrogate.class).value()), (Object)(surrogateClass.getAnnotation(JsonSurrogate.class).value().getName() + " must derive from ServiceException"));
        this.exceptionMessageBuilder.registerSurrogate(surrogateClass);
    }

    private Response.ResponseBuilder createResponseBuilder(ServiceException e) {
        Class<?> clazz = e.getClass();
        while (ServiceException.class.isAssignableFrom(clazz)) {
            Response.Status status = STATUS_MAP.get(clazz);
            if (status != null) {
                return ResponseFactory.status(status);
            }
            clazz = clazz.getSuperclass();
        }
        return ResponseFactory.serverError();
    }

    static {
        log = LoggerFactory.getLogger(ServiceExceptionMapper.class);
        STATUS_MAP = ImmutableMap.builder().put(ArgumentValidationException.class, (Object)Response.Status.BAD_REQUEST).put(AuthenticationRequiredException.class, (Object)Response.Status.OK).put(AuthorisationException.class, (Object)Response.Status.UNAUTHORIZED).put(DuplicatePullRequestException.class, (Object)Response.Status.CONFLICT).put(EntityOutOfDateException.class, (Object)Response.Status.CONFLICT).put(FeatureDisabledException.class, (Object)Response.Status.CONFLICT).put(ForbiddenException.class, (Object)Response.Status.FORBIDDEN).put(IllegalEntityStateException.class, (Object)Response.Status.CONFLICT).put(IntegrityException.class, (Object)Response.Status.CONFLICT).put(InvalidPullRequestReviewersException.class, (Object)Response.Status.CONFLICT).put(InvalidLicenseException.class, (Object)Response.Status.BAD_REQUEST).put(LicenseLimitException.class, (Object)Response.Status.FORBIDDEN).put(LimitExceededException.class, (Object)Response.Status.BAD_REQUEST).put(IncompatibleLicenseChangeException.class, (Object)Response.Status.CONFLICT).put(MergeException.class, (Object)Response.Status.CONFLICT).put(NoSuchEntityException.class, (Object)Response.Status.NOT_FOUND).put(PageStartOutOfBoundsException.class, (Object)Response.Status.NOT_FOUND).put(PullRequestMergeVetoedException.class, (Object)Response.Status.CONFLICT).put(RequestCanceledException.class, (Object)Response.Status.BAD_REQUEST).put(UnmodifiablePullRequestRoleException.class, (Object)Response.Status.CONFLICT).build();
    }
}

