/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.enrich;

import com.atlassian.bitbucket.avatar.AvatarRequest;
import com.atlassian.bitbucket.avatar.AvatarService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.user.RestPerson;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.google.common.base.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class DefaultAvatarEnricher
implements AvatarEnricher {
    private final AvatarService avatarService;

    public DefaultAvatarEnricher(AvatarService avatarService) {
        this.avatarService = avatarService;
    }

    @Override
    public void enrich(@Nonnull Object entity, @Nullable AvatarRequest avatarRequest) {
        if (avatarRequest != null) {
            try (Timer ignored = TimerUtils.start((String)"AvatarEnricher.enrich");){
                this.setAvatarUrls(entity, avatarRequest);
            }
        }
    }

    private void setAvatarUrls(Object entity, final AvatarRequest request) {
        RestUtils.processEntities(entity, new Function<Object, Object>(){

            public Object apply(Object entity) {
                if (entity instanceof RestPerson) {
                    RestPerson person = (RestPerson)entity;
                    person.setAvatarUrl(DefaultAvatarEnricher.this.avatarService.getUrlForPerson((Person)person, request));
                } else if (entity instanceof RestProject) {
                    RestProject project = (RestProject)entity;
                    project.setAvatarUrl(DefaultAvatarEnricher.this.avatarService.getUrlForProject((Project)project, request));
                }
                return entity;
            }
        });
    }
}

