/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.rest.admin;

import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.mail.MailProtocol;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.rest.mail.RestMailConfiguration;
import com.atlassian.bitbucket.rest.util.ResponseFactory;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Objects;
import com.sun.jersey.spi.resource.Singleton;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;

@AnonymousAllowed
@Consumes(value={"application/json"})
@Path(value="admin/mail-server")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class MailServerResource {
    private final PermissionValidationService permissionValidationService;
    private final ApplicationPropertiesService propertiesService;
    private final TransactionTemplate transactionTemplate;
    public static final String EXAMPLE_SENDER_ADDRESS = "stash-no-reply@company.com";

    public MailServerResource(PermissionValidationService permissionValidationService, ApplicationPropertiesService propertiesService, TransactionTemplate transactionTemplate) {
        this.permissionValidationService = permissionValidationService;
        this.propertiesService = propertiesService;
        this.transactionTemplate = transactionTemplate;
    }

    @DELETE
    public Response deleteMailConfig() {
        this.propertiesService.deleteMailHostConfiguration();
        this.propertiesService.setServerEmailAddress(null);
        return ResponseFactory.noContent().build();
    }

    @GET
    public Response getMailConfig() {
        this.permissionValidationService.validateForGlobal(Permission.SYS_ADMIN);
        MailHostConfiguration configuration = this.propertiesService.getMailHostConfiguration();
        String senderAddress = this.propertiesService.getServerEmailAddress();
        return configuration == null && senderAddress == null ? ResponseFactory.notFound().build() : ResponseFactory.ok(new RestMailConfiguration(configuration, senderAddress)).build();
    }

    @PUT
    public Response setMailConfig(final RestMailConfiguration configuration) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction() {
                if (StringUtils.isNotBlank((String)configuration.getHostname())) {
                    MailServerResource.this.propertiesService.setMailHostConfiguration(new MailHostConfiguration.Builder().hostname(configuration.getHostname()).port(configuration.getPort()).protocol((MailProtocol)Objects.firstNonNull((Object)configuration.getProtocol(), (Object)MailProtocol.SMTP)).requireStartTls(configuration.isRequireStartTls()).useStartTls(configuration.isUseStartTls()).username(configuration.getUsername()).password(configuration.getPassword()).build());
                }
                if (StringUtils.isNotBlank((String)configuration.getSenderAddress())) {
                    MailServerResource.this.propertiesService.setServerEmailAddress(configuration.getSenderAddress());
                }
                return null;
            }
        });
        return ResponseFactory.ok(new RestMailConfiguration(this.propertiesService.getMailHostConfiguration(), this.propertiesService.getServerEmailAddress())).build();
    }

    @DELETE
    @Path(value="sender-address")
    public Response clearSenderAddress() {
        this.propertiesService.setServerEmailAddress(null);
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="sender-address")
    public Response getSenderAddress() {
        String address = this.propertiesService.getServerEmailAddress();
        return address == null ? ResponseFactory.notFound().build() : ResponseFactory.ok(address).build();
    }

    @PUT
    @Path(value="sender-address")
    public Response setSenderAddress(String senderAddress) {
        this.propertiesService.setServerEmailAddress(senderAddress);
        return ResponseFactory.ok(this.propertiesService.getServerEmailAddress()).build();
    }
}

