/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.util;

import com.google.common.base.Function;
import java.io.Closeable;
import java.io.IOException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonStreamContext;

public class StatefulJsonWriter
implements Closeable {
    private final JsonGenerator generator;

    public StatefulJsonWriter(JsonGenerator generator) {
        this.generator = generator;
    }

    public StatefulJsonWriter beginArray() throws IOException {
        this.generator.writeStartArray();
        return this;
    }

    public StatefulJsonWriter endArray() throws IOException {
        this.generator.writeEndArray();
        return this;
    }

    public StatefulJsonWriter beginObject() throws IOException {
        this.generator.writeStartObject();
        return this;
    }

    public StatefulJsonWriter endObject() throws IOException {
        this.generator.writeEndObject();
        return this;
    }

    public StatefulJsonWriter name(String name) throws IOException {
        this.generator.writeFieldName(name);
        return this;
    }

    public StatefulJsonWriter value(String value) throws IOException {
        this.generator.writeString(value);
        return this;
    }

    public StatefulJsonWriter nullValue() throws IOException {
        this.generator.writeNull();
        return this;
    }

    public StatefulJsonWriter value(boolean value) throws IOException {
        this.generator.writeBoolean(value);
        return this;
    }

    public StatefulJsonWriter value(double value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public StatefulJsonWriter value(long value) throws IOException {
        this.generator.writeNumber(value);
        return this;
    }

    public StatefulJsonWriter value(Object value) throws IOException {
        this.generator.writeObject(value);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    public StatefulJsonWriter endToDocument() throws IOException {
        JsonStreamContext context;
        do {
            context = this.generator.getOutputContext();
            JsonStreamContext parent = context.getParent();
            switch (this.getWritingState().getContext()) {
                case NAME: {
                    this.generator.writeNull();
                    break;
                }
                case ROOT: {
                    break;
                }
                case ARRAY: {
                    this.generator.writeEndArray();
                    break;
                }
                case OBJECT: {
                    if (parent.inRoot()) {
                        return this;
                    }
                    this.generator.writeEndObject();
                }
            }
        } while (!context.inRoot());
        return this;
    }

    public WritingState getWritingState() {
        JsonStreamContext context = this.generator.getOutputContext();
        int entryCount = context.getEntryCount();
        if (context.getCurrentName() != null) {
            return new WritingState(WritingContext.NAME, entryCount);
        }
        if (context.inArray()) {
            return new WritingState(WritingContext.ARRAY, entryCount);
        }
        if (context.inObject()) {
            return new WritingState(WritingContext.OBJECT, entryCount);
        }
        if (context.inRoot()) {
            return new WritingState(WritingContext.ROOT, entryCount);
        }
        return null;
    }

    public void flush() throws IOException {
        this.generator.flush();
    }

    @Override
    public void close() throws IOException {
        this.generator.close();
    }

    public StatefulJsonWriter transform(final Function<Object, Object> function) {
        return new StatefulJsonWriter(this.generator){

            @Override
            public StatefulJsonWriter value(Object value) throws IOException {
                return StatefulJsonWriter.this.value(function.apply(value));
            }
        };
    }

    public static enum WritingContext {
        ROOT,
        ARRAY,
        OBJECT,
        NAME;

    }

    public static class WritingState {
        private WritingContext context;
        private int entryCount;

        public WritingState(WritingContext context, int entryCount) {
            this.context = context;
            this.entryCount = entryCount;
        }

        public WritingContext getContext() {
            return this.context;
        }

        public int getEntryCount() {
            return this.entryCount;
        }
    }
}

