/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.hook.repository;

import com.atlassian.bitbucket.hook.repository.RepositoryHook;
import com.atlassian.bitbucket.hook.repository.RepositoryHookDetails;
import com.atlassian.bitbucket.hook.repository.RepositoryHookType;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=RepositoryHook.class)
public class RestRepositoryHook
extends RestMapEntity
implements RepositoryHook {
    private static final String DETAILS = "details";
    private static final String ENABLED = "enabled";
    private static final String CONFIGURED = "configured";
    public static final Function<RepositoryHook, RestRepositoryHook> TO_REST = new Function<RepositoryHook, RestRepositoryHook>(){

        public RestRepositoryHook apply(RepositoryHook descriptor) {
            return new RestRepositoryHook(descriptor);
        }
    };
    public static final RestRepositoryHook EXAMPLE = new RestRepositoryHook(new RestRepositoryHookDetails("com.atlassian.stash.plugin.example:example-repository-hook", "Example repository hook", RepositoryHookType.PRE_RECEIVE, "An example description for an example hook.", "1.2.4", null), true, true);
    public static final RestPage<RestRepositoryHook> PAGE_EXAMPLE = RestDocUtils.pageOf(EXAMPLE);

    public RestRepositoryHook(RestRepositoryHookDetails details, boolean isEnabled, boolean configured) {
        this.put(DETAILS, details);
        this.put(ENABLED, isEnabled);
        this.put(CONFIGURED, configured);
    }

    public RestRepositoryHook(RepositoryHook descriptor) {
        this(new RestRepositoryHookDetails(descriptor.getDetails()), descriptor.isEnabled(), descriptor.isConfigured());
    }

    @Nonnull
    public RepositoryHookDetails getDetails() {
        Object details = Preconditions.checkNotNull(this.get(DETAILS), (Object)DETAILS);
        if (details instanceof RepositoryHookDetails) {
            return (RepositoryHookDetails)details;
        }
        if (details instanceof Map) {
            return new RestRepositoryHookDetails((Map)details);
        }
        throw new IllegalStateException("details of type " + details.getClass().getName() + " are not supported");
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED);
    }

    public boolean isConfigured() {
        return this.getBoolProperty(CONFIGURED);
    }

    @JsonSerialize
    private static class RestRepositoryHookDetails
    extends RestMapEntity
    implements RepositoryHookDetails {
        private static final String KEY = "key";
        private static final String NAME = "name";
        private static final String TYPE = "type";
        private static final String DESCRIPTION = "description";
        private static final String VERSION = "version";
        private static final String CONFIG_FORM_KEY = "configFormKey";

        private RestRepositoryHookDetails(Map<String, Object> map) {
            super(map);
        }

        public RestRepositoryHookDetails(RepositoryHookDetails details) {
            this(details.getKey(), details.getName(), details.getType(), details.getDescription(), details.getVersion(), details.getConfigFormKey());
        }

        private RestRepositoryHookDetails(String key, String name, RepositoryHookType type, String description, String version, String configFormKey) {
            this.put(KEY, key);
            this.put(NAME, name);
            this.put(TYPE, type);
            this.put(DESCRIPTION, description);
            this.put(VERSION, version);
            this.put(CONFIG_FORM_KEY, configFormKey);
        }

        public String getKey() {
            return this.getStringProperty(KEY);
        }

        public String getName() {
            return this.getStringProperty(NAME);
        }

        public RepositoryHookType getType() {
            return this.getEnumProperty(TYPE, RepositoryHookType.class);
        }

        @Nullable
        public String getDescription() {
            return this.getStringProperty(DESCRIPTION);
        }

        public String getVersion() {
            return this.getStringProperty(VERSION);
        }

        @Nullable
        public String getConfigFormKey() {
            return this.getStringProperty(CONFIG_FORM_KEY);
        }
    }
}

