/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rest.content;

import com.atlassian.bitbucket.content.DiffHunk;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.content.RestDiffSegment;
import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
@JsonSurrogate(value=DiffHunk.class)
public class RestDiffHunk
extends RestMapEntity {
    public static final Function<DiffHunk, RestDiffHunk> REST_TRANSFORM = new Function<DiffHunk, RestDiffHunk>(){

        public RestDiffHunk apply(DiffHunk hunk) {
            return new RestDiffHunk(hunk);
        }
    };
    public static final RestDiffHunk HUNKY_EXAMPLE = new RestDiffHunk(1, 1, 1, 2, Lists.newArrayList((Object[])new RestDiffSegment[]{RestDiffSegment.REMOVED_SOURCE_EXAMPLE, RestDiffSegment.ADDED_DEST_EXAMPLE}), false);
    public static final RestDiffHunk HUNKY_EXAMPLE_COMMENTED = new RestDiffHunk(1, 1, 1, 2, Lists.newArrayList((Object[])new RestDiffSegment[]{RestDiffSegment.REMOVED_SOURCE_EXAMPLE, RestDiffSegment.ADDED_DEST_EXAMPLE_COMMENTED}), false);

    public RestDiffHunk() {
    }

    public RestDiffHunk(DiffHunk hunk) {
        this(hunk.getSourceLine(), hunk.getSourceSpan(), hunk.getDestinationLine(), hunk.getDestinationSpan(), RestDiffHunk.transform(hunk.getSegments(), RestDiffSegment.REST_TRANSFORM), hunk.isTruncated());
    }

    private RestDiffHunk(int sourceLine, int sourceSpan, int destinationLine, int destinationSpan, List<RestDiffSegment> segments, boolean isTruncated) {
        this.putIfNotNull("sourceLine", sourceLine);
        this.putIfNotNull("sourceSpan", sourceSpan);
        this.putIfNotNull("destinationLine", destinationLine);
        this.putIfNotNull("destinationSpan", destinationSpan);
        this.putIfNotEmpty("segments", (Collection<?>)segments);
        this.putIfNotNull("truncated", isTruncated);
    }
}

