/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.secretscanning;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import javax.annotation.Nullable;

@JsonSerialize
public class RestSecretScanningRuleSetRequest
extends RestMapEntity {
    private static final String LINE_REGEX = "lineRegex";
    private static final String NAME = "name";
    private static final String PATH_REGEX = "pathRegex";

    public RestSecretScanningRuleSetRequest() {
    }

    public RestSecretScanningRuleSetRequest(@Nullable String name, @Nullable String lineRegex, @Nullable String pathRegex) {
        this.put(NAME, name);
        this.put(LINE_REGEX, lineRegex);
        this.put(PATH_REGEX, pathRegex);
    }

    @Schema(description="Regular expression for matching a secret on a code line", example="(BBDC-[a-zA-Z0-9+]{44})")
    @Nullable
    public String getLineRegex() {
        return this.getStringProperty(LINE_REGEX);
    }

    @Schema(description="Human readable name for the rule", example="Bitbucket DC HTTP access token")
    @Nullable
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @Schema(description="Regular expression matching file names", example="*.pem")
    @Nullable
    public String getPathRegex() {
        return this.getStringProperty(PATH_REGEX);
    }
}

