/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dmz.rest.v2.x509;

import com.atlassian.bitbucket.dmz.x509.DmzX509Certificate;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import javax.annotation.Nonnull;

@JsonSerialize
public class RestX509Certificate
extends RestMapEntity {
    private static final String FINGERPRINT = "fingerprint";
    private static final String ID = "id";

    public RestX509Certificate() {
    }

    public RestX509Certificate(@Nonnull DmzX509Certificate certificate) {
        Objects.requireNonNull(certificate, "certificate");
        this.put(FINGERPRINT, certificate.getFingerprint());
        this.put(ID, certificate.getId());
    }

    @Nonnull
    @Schema(description="The SHA-256 fingerprint of the X.509 certificate", example="e5e8d632c0b86f5bd5ef9a0d55c58ba1fd7776f6bb7c35ca23d85d23281ce58f")
    public String getFingerprint() {
        return this.getStringProperty(FINGERPRINT);
    }

    @Schema(description="The ID of the X.509 certificate", example="7")
    public long getId() {
        return this.getLongProperty(ID);
    }
}

